/**
* @file StatusBar.cpp
* @brief Status Bar / Xe[^Xo[\ACӂ̕\܂
* @author OKADA, H.
* @date 2011/01/07
* Copyright (C) 2014 Shimadzu Corporation All rights reserved.
* <⑫>
*   gG
*     0. StatusBar.h include܂B
*     1. Xe[^Xo[̃CX^X擾܂B
*        kome::window::StatusBar& statusBar = kome::window::StatusBar::getInstance(); 
*     2. Xe[^Xo[̃o֐A setStatusMsg()pĕ\w肵܂
*        statusBar.setStatusMsg( "common", "TEST" ); ij
*     3. Xe[^Xo[̈ԍ̗̖̈O"common"ƌ܂Ă̂ŁÄ̗"TEST"ƕ\܂
*     4. q悤xmlt@Cstatus-bar^Ow肵ꍇÄ̗ȊOɓƎ̗̈mۂĕ\ł܂
*     5. Xe[^Xo[̗̈𖳌ɂ邱Ƃo܂Bȉ̂悤ɂƁA"VerticalBox"Œ`̈悪Ȃ܂B
*        statusBar.setFlgDisp( "VerticalBox", 0 );
*        ēxLɂꍇ́AL01ɕύX܂BȂA"common"𖳌ɂ邱Ƃ͂ł܂B
*   
*       "common"ȊÖ̗ݒ肷ɂ́AvOCxmlt@Cplugin.xmlɈȉ̂悤ɋLq܂B
*   
*	  <gui>
*		<status-bar target="spectrum"  order="127">
*		  <status-bar-name>VerticalBox</status-bar-name>
*		</status-bar>
*	  </gui>
*   
*	    targetɂ "none", "spectrum", "chromatogram", "datamap" ̂ꂩw肵܂BƂ
*     target"spectrum"w肵ꍇAANeBuȃEChEXyNg̏ꍇɂ̃Xe[^Xo[\܂B
*     XyNgƃN}gOŕ\Ƃꍇ́Aq悤status-bar^O𕡐܂B
*       orderɂ́A\̗Dxw肵܂BXe[^Xo[ꍇA琔Ȃɕ\܂B
*     1`255ڈɐݒ肵ĉBDx̒lƏdȂꍇ̕\͖`łB܂A"common"̗Dx0łB
*       status-bar-name^Oɂ́AXe[^Xo[̖Ow肵܂B̃vOCœOw肷ƁA
*     ̈ɕ\sƂo܂B
*       status-bar^ÓALqł܂Bstatus-bar-name^O^O𕡐LqꍇA2ڈȍ~order͖܂B
*     ȉ̗ł́AuVerticalBoxvƂÕXe[^Xo[ݒ肵AspectrumchromatogramANeBuȂƂɁA
*     setStatusMsg()֐Ŏw肵񂪕\悤ɂȂ܂B
*	  <gui>
*		<status-bar target="spectrum"  order="127">
*		  <status-bar-name>VerticalBox</status-bar-name>
*		</status-bar>
*		<status-bar target="chromatogram"  order="100">   uorder="100"v2ڂȂ̂Ŗ܂
*		  <status-bar-name>VerticalBox</status-bar-name>
*		</status-bar>
*	  </gui>
*   
*   
*   
*/

#include "Stdafx.h"
#include "StatusBar.h"

#include "ChildFrame.h"

using kome::window::StatusBar;


#define MAX_SIZE 10			// @date 2011.10.19 <Add> M.Izumi

// z̗vf𓾂_countof()}N̒`(|C^w肵Ă͂ȂȂ)
#ifndef _countof
	#define _countof(array)	sizeof(array)/sizeof((array)[0])
#else
#endif

// constructor
StatusBar::StatusBar() {
	m_pStatbar = NULL;
	m_pFrame = NULL;
	getMainWindow();	// @date 2011/01/26 <Add> OKADA
	getStatusBarInfo();
}

// destructor
StatusBar::~StatusBar() {
}

// get refer to PluginManager object
StatusBar& StatusBar::getInstance( void ) {
	// create the only object
	static StatusBar statusBar;

	return statusBar;
}

// xmlt@Cǂݍ܂ꂽXe[^Xo[SĎ擾
void StatusBar::getStatusBarInfo( void )
{
	kome::plugin::PluginManager& plgMgr = kome::plugin::PluginManager::getInstance();

	int iCountOfPlugin = plgMgr.getNumberOfPlugins();
	int iCountOfSourceStatusBarInfos;
	kome::plugin::StatusBarInfo* p_tempStatusBarInfo; 

	for( int i=0; i<iCountOfPlugin; i++ ){
		iCountOfSourceStatusBarInfos = plgMgr.getPlugin( i )->getNumberOfStatusBarInfos();
		if( iCountOfSourceStatusBarInfos != 0 ){
			for( int j=0; j<iCountOfSourceStatusBarInfos; j++ ){
				p_tempStatusBarInfo = plgMgr.getPlugin( i )->getStatusBarInfo( j );

				// StatusBarInfoP擾

				int iCountOfTotal = m_totalStatusBarInfo.size();
				int flgIcchi = 0;	// v(ɓo^Ă)uPv

				for( int k=0; k<iCountOfTotal; k++ ){
					if (strcmp( m_totalStatusBarInfo[k].getName(), p_tempStatusBarInfo->getName() ) ){
						// sv
					}else{
						// v
						flgIcchi = 1;
						m_totalStatusBarInfo[k].setTargetVal( p_tempStatusBarInfo->getTargetVal() );
						m_totalStatusBarInfo[k].setPlugin( p_tempStatusBarInfo->getPlugin() );
						m_totalStatusBarInfo[k].setWidth( p_tempStatusBarInfo->getWidth() ); // @date 2011.10.19 <Add> M.Izuimi
						break;	// I
					}
				}
	
				if( flgIcchi == 0 ){
					// xvȂ->Vɒǉ
					m_totalStatusBarInfo.push_back( *p_tempStatusBarInfo );
				}
			}
		}
	}

	// sort statusbar vector / 擾Xe[^Xo[ordeȑɕёւ
	// m_totalStatusBarInfoordeȑsort܂
	int iCountOfTotalStatusBarInfo = m_totalStatusBarInfo.size();

	// sortCu֐ōsꍇ
	std::stable_sort( m_totalStatusBarInfo.begin(), m_totalStatusBarInfo.end() );

	int iiii = 0;
}


void StatusBar::getMainWindow( void )
{
	m_pFrame = (MainFrame*)kome::window::WindowTool::getMainWindow();

	if( m_pFrame != NULL ){
		if( m_pStatbar == NULL ){
			m_pStatbar = m_pFrame->CreateStatusBar();
		}
	}
}

// "hoge" ƂL[w肵āAɕ\鏈
int StatusBar::setStatusMsg( const char* szPos, const char* szMessage )
{
	// L[
	int nPos = getPositionByName( szPos );
	if( nPos < 0 || m_pStatbar == NULL ){	// sv
		return -1;	// err
	}else{
		// \w
		m_totalStatusBarInfo[nPos].setMessage( szMessage );
		// \
		dispAuto();

		// @date 2011.10.19 <Add> M.Izumi
		int aryWidth[MAX_SIZE];
		for (int i=0; i < _countof( aryWidth ); i++) {
			aryWidth[i] = 0;
		}

		for( unsigned int i=0; i < m_totalStatusBarInfo.size(); i++ ){
			if( strcmp( m_totalStatusBarInfo[i].getName() , "common" ) == 0 ){
				aryWidth[i] = 540;
			}else{
				aryWidth[i] = m_totalStatusBarInfo[i].getWidth();
			}
		}
		
		m_pStatbar->SetStatusWidths( m_totalStatusBarInfo.size(), aryWidth );
		
	}

	return 0;
}

//  Xe[^Xo[́Aݕ\ׂۂ肷֐ ԒlF0=\ׂłȂ 1=\ׂ
int StatusBar::isDispNow( kome::plugin::StatusBarInfo& statusBarInfo )
{
	kome::plugin::StatusBarInfo::StatusBarTargetValue targetVal;

	if( statusBarInfo.getFlgDisp() == 0 ){
		return 0;
	}

	targetVal = statusBarInfo.getTargetVal();
	if( targetVal == kome::plugin::StatusBarInfo::VAL_SB_TGT_NONE ){
		return 1;
	}else{
		kome::plugin::StatusBarInfo::StatusBarTargetValue activeWindowKind;
		activeWindowKind = getActiveWindowKind();

		if( activeWindowKind & targetVal ){
			return 1;
		}
	}

	return 0;
}

// ݃ANeBuȃEChE̎ނ擾
// ԒlG
//   VAL_SB_TGT_OTHER			ANeBuȃEChE擾łȂ
//   VAL_SB_TGT_NONE			ANeBuȃEChÉAspectrum, chromatogram, datamap̂ǂłȂ
//   VAL_SB_TGT_SPECTRUM		ANeBuȃEChÉAspectrum
//   VAL_SB_TGT_CHROMATOGRAM	ANeBuȃEChÉAchromatogram
//   VAL_SB_TGT_DATAMAP			ANeBuȃEChÉAdatamap
kome::plugin::StatusBarInfo::StatusBarTargetValue StatusBar::getActiveWindowKind( void )
{
	kome::window::ChildFrame* frame = kome::window::ChildFrame::getActiveFrame();

	unsigned int specNum = 0;
	unsigned int chromNum = 0;
	unsigned int mapNum = 0;

	if( frame != NULL ) {
		specNum = frame->getNumberOfSpectra();
		chromNum = frame->getNumberOfChromatograms();
		mapNum = frame->getNumberOfDataMaps();
	}else{
		return kome::plugin::StatusBarInfo::VAL_SB_TGT_OTHER;
	}

	if( (0 < specNum) && (chromNum == 0) && (mapNum == 0) ) {
		// Spectrum ANeBu
		return kome::plugin::StatusBarInfo::VAL_SB_TGT_SPECTRUM;
	}
	else if( (specNum == 0) && (0 < chromNum) && (mapNum == 0) ) {
		// Chromatogram ANeBu
		return kome::plugin::StatusBarInfo::VAL_SB_TGT_CHROMATOGRAM;
	}
	else if( (specNum == 0) && (chromNum == 0) && (0 < mapNum) ) {
		// Data Map ANeBu
		return kome::plugin::StatusBarInfo::VAL_SB_TGT_DATAMAP;
	}
	else {
		// None
	}

	return kome::plugin::StatusBarInfo::VAL_SB_TGT_NONE;
}

// SẴXe[^Xo[`FbNāA\ׂ̂\
void StatusBar::dispAuto( void )
{
	int iCountOfTotalStatusBarInfo = m_totalStatusBarInfo.size();	// ۂɂ́A\ׂXe[^Xo[̌𐔂 iCountOfTotalStatusBarInfo ɑ
	int iFieldsCount = 0;

	if( m_pStatbar == NULL ){
		return;
	}
	
	// \ׂtB[h̐ݒ肷
	m_pStatbar->SetFieldsCount( iCountOfTotalStatusBarInfo );	

	// \ׂtB[ĥݕ\	
	// Spec No.86227 When dragging on an area in the Heatmap, the end position RT value is not shown in the status bar @date 2012.07.03 <Mod> M.Izumi
	for( int i=0; i<iCountOfTotalStatusBarInfo; i++ ){
		if( m_pStatbar != NULL ){
			if( 0 < isDispNow( m_totalStatusBarInfo[i] ) ){				
				m_pStatbar->SetStatusText( m_totalStatusBarInfo[i].getMessage(), i );				
			}
		}
	}

}


int StatusBar::getPositionByName( const char* szName )
{
	// L[
	int iCountOfTotalStatusBarInfo = m_totalStatusBarInfo.size();

	for( int i=0; i<iCountOfTotalStatusBarInfo; i++ ){
		if( strcmp( m_totalStatusBarInfo[i].getName(), szName ) == 0 ){
			// v
			return i;
		}
	}

	return -1;	// err
}


int StatusBar::setFlgDisp(  const char* szPos, int flgDisp )
{
	// L[
	int nPos = getPositionByName( szPos );
	if( nPos < 0 ){	// sv
		return -1;	// err
	}else{
		// \w
		m_totalStatusBarInfo[nPos].setFlgDisp( flgDisp );
		// \
		dispAuto();
	}

	return 0;
}
