/**
 * @file XMLMaker
 * @brief MassBankXML𐶐
 *
 * @author M.Fukuda
 * @date 2013.04.24
 *
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */

#pragma once

namespace kome {
	namespace massbank {

		class XMLMaker {
		public:
			// constructor
			XMLMaker();

			// descructor
			~XMLMaker();
		private:
			// onAppendFixedgۂɁAꎞIɎgB
			kome::objects::SettingParameterValues* settings_;

			// PrivateMethod
			std::string xml_;
			std::string method_;
			bool hasExFg_;       // ver 2.6.0  searchSpectrumEx ExnɑΉۂ

		public:
			// XML擾
			std::string getXML() const { return xml_;}

			// method擾
			std::string getMethod() const { return method_;}

			void setHasExFg(const bool fg) {hasExFg_ = fg;}

			// Instruments擾XML
			void setGetInstrumentTypes();

			// spectrum search擾XML
			void setSimilarSpectraXML(
				kome::core::XYData& peaks,
				kome::objects::SettingParameterValues* settings,
				const std::string& tgtinstruments);

			// Batch SearchsXML
			void setBatchSearchXML(
				std::vector<kome::objects::Spectrum*> spectra,
				kome::objects::SettingParameterValues* settings,
				const std::string& tgtinstruments);

			void setBatchSearchXML(
				const std::string& specQuerys,
				kome::objects::SettingParameterValues* settings);


			// search peaks / diff.. s XML
			void setSearchPeaksXML(
				kome::objects::SettingParameterValues* settings,
				const std::string& tgtinstruments);

			void setDiffSearchPeaksXML(
				kome::objects::SettingParameterValues* settings,
				const std::string& tgtinstruments);


			void setGetJobStatus(const std::string& jobId);

			void setGetJobResult(const char* jobId);

			void setGetRecordInfo(const char* jobId);

			void setGetPeak(const char* jobId);

			const std::string getQueryStringsTag(
				const char* scanname,
				kome::objects::Peaks* peaks);

			const std::string onGetInstrumentTypesTag();

			const std::string onGetInstrumentTypesTag(
				const std::vector<std::string>& instrumenttypes);

		private:
			// Job ID̃^O쐬
			const std::string onSetJB_ID(const char* jobId);

			const std::string onAppendFixedDouble(
				const std::string& tgt,
				const double value
				);

			// [ɑ(sType) XMLԂ
			const std::string onAppendFixedType(
				const std::string& tgt,
				const int sType);

			const std::string onAppendFixedTypes(
				const int sType,
				const std::string& tagPtr,
				const std::string& tgt,
				const bool noParamFg = false
				);


			const std::string onSetMZSArray(const std::string& listKey);

			// MassBank XML쐬
			const std::string onSetMSBKFormat();

			// MassBank XML쐬icontent..Ԃɋݍ)
			const std::string onSetMSBKFormat(const std::string& contentReq);

			// Job..nXML쐬(methodႤj
			void onSetJobStatus(
				const std::string& method,
				const char* jobId);

			// TesẗׂXMLR[h쐬
			const std::string onMakeTestXML_searchSpectrum(const bool exFg);
			const std::string onMakeTestXML_searchPeak(const bool exFg);
			const std::string onMakeTestXML_searchPeakDiff(const bool exFg);

		};
	}
}
