/**
 * @file CreatePanelToolOfCreatePanel.h
 * @brief Panel Create Support
 *
 * @author M.Fukuda
 * @date 2013.02.22
 *
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */

#pragma once

#include <vector>

namespace pfc {
//^
	const int knNoUse(-INT_MAX);
	const double kdNoUse(-DBL_MAX);

// ʂ@wb_AC̍쐬s
// param[in] parent    eWindow
// param[in] addrownum ČɒǉvfB
// param[in] headLabel wb_x̓e
// Sizer͍ŒłQiwb_xƃCjmۂĂāA
// Xɒǉ`ɂȂ
wxFlexGridSizer* createHeaders(
	wxWindow* parent,
	const int addrownum,
	const wxString& headLabel
	);

//SettingsParamւ̒`쐬
//Param[in] sName  : p[^̖OB
//Param[in] holdfg : MassBank Section & sNamẽATC
kome::plugin::SettingsParam* onSetParamAdpt (
	kome::plugin::ParameterSettings& inParams,
	kome::plugin::SettingsValue*& val,
	const std::string& sName,
	bool holdfg = false);

void addEnumItem(	
	kome::plugin::SettingsValue*& val,
	const std::string& str1
	);

//SettingsFormւ̒`쐬
//Param[in] sTitle  : tH[
//Param[in] sDesc   : tH[̐
kome::plugin::SettingsForm* onSetFormAdpt(
	kome::plugin::SettingsPage*& page,
	kome::plugin::SettingsParam*& param,
	const std::string& sTitle,
	const std::string& sDesc);

//ParameterSettingsցAval,pageɊtB
//  Param[in] inParams : param̌ɂȂparam
//  Param[in] val      : paramɊ蓖Ăval
//  Param[in] page     : form̌ɂȂpage
//  Param[in] sName    : p[^̖O
//  Param[in] sTitle   : tH[
//  Param[in] sDesc    : tH[̐
//  Param[in] holdfg   : ۑpMassBank Section邩ۂ
void setParamAndFormAdpt (
	kome::plugin::ParameterSettings& inParams,
	kome::plugin::SettingsValue*& val,
	kome::plugin::SettingsPage*& page,
	const std::string& sName,
	const std::string& sTitle,
	const std::string& sDesc,
	bool holdfg = false);

//ParameterSettingsցAval,pageɊtB
//  Param[in] inParams : param̌ɂȂparam
//  Param[in] val      : paramɊ蓖Ăval
//  Param[in] page     : form̌ɂȂpage
//  Param[in] sgroup   : form̑O[v
//  Param[in] sName    : p[^̖O
//  Param[in] sTitle   : tH[
//  Param[in] sDesc    : tH[̐
//  Param[in] holdfg   : ۑpMassBank Section邩ۂ
void setParamAndFormAdptGroup (
	kome::plugin::ParameterSettings& inParams,
	kome::plugin::SettingsValue*& val,
	kome::plugin::SettingsPage*& page,
	kome::plugin::SettingsGroup* sgroup,
	const std::string& sName,
	const std::string& sTitle,
	const std::string& sDesc,
	bool holdfg = false);

// SubTag & Value ́@ListCtrl Value쐬B
kome::plugin::SettingsValue* setSubTagListValue (
	kome::plugin::ParameterSettings& inParams,
	const std::vector<std::string>& subtagArr,
	const std::vector<std::string>* subtagNGArr = nullptr);

kome::plugin::SettingsValue* setListChildStringValue (
	kome::plugin::ParameterSettings& inParams,
	const std::string& childname,
	const std::vector<std::string>* childval,
	const bool required,
	const bool hasChecked = false
	);

// String  Value 쐬
//  Param[in] inParams : param̌ɂȂparam
//  Param[in] def      : ftHglBgȂƂ ""
//  Param[in] reqFlg   : ͕K{ڂH Y/N
//  Return    SettingsValue Object Pointer
kome::plugin::SettingsValue* createStringSTValue(
	kome::plugin::ParameterSettings& params,
	const std::string& def,
	const bool reqFlg);

// Integer  Value 쐬
//  Param[in] inParams : param̌ɂȂparam
//  Param[in] nMin     : ŏlBgȂꍇ knNoUse.
//  Param[in] nMax     : őlBgȂꍇ knNoUse.
//  Param[in] def      : ftHglBgȂƂ ""
//  Param[in] reqFlg   : ͕K{ڂH Y/N
//  Return    SettingsValue Object Pointer
kome::plugin::SettingsValue* createIntegerSTValue(
	kome::plugin::ParameterSettings& params,
	const int nMin,
	const int nMax, 
	const std::string& def,
	const bool reqFlg);

// Double  Value 쐬
//  Param[in] inParams : param̌ɂȂparam
//  Param[in] dMin     : ŏlBgȂꍇ kdNoUse.
//  Param[in] dMax     : őlBgȂꍇ kdNoUse.
//  Param[in] def      : ftHglBgȂƂ ""
//  Param[in] reqFlg   : ͕K{ڂH Y/N
//  Return    SettingsValue Object Pointer
kome::plugin::SettingsValue* createDoubleSTValue(
	kome::plugin::ParameterSettings& params,
	const double dmin,
	const double dMax,
	const std::string& def,
	const bool reqFlg);

}
