package PluginManager::Util;

use strict;
use warnings;

use File::Temp;
use Exporter;

our @EXPORT = qw(tempdir tempfile);
use base qw(Exporter);

my $tmp_dir = undef;

sub tempdir {
	$tmp_dir ||= MT->config('TempDir');
	File::Temp::tempdir(@_, DIR => $tmp_dir);
}

sub tempfile {
	$tmp_dir ||= MT->config('TempDir');
	File::Temp::tempfile(@_, DIR => $tmp_dir);
}

1;
