#!/usr/bin/perl

use strict;
use Facebook::Graph;
use Config::Any;
use Hash::Merge::Simple;
use Data::Recursive::Encode;
use Data::Dumper;

my %cfg;

my $config_name = $ARGV[0] || 'not_found';

my $cfg = {};
my $config_path = ['/etc/mubot4fb/'.$config_name,
		   $ENV{HOME} . '/.mubot4fb/'. $config_name,
		   $ENV{PWD} . '/mubot4fb_' . $config_name];

my $c = Config::Any->load_stems({stems => $config_path,  use_ext => 1, flatten_to_hash => 1});
foreach my $i (keys %$c) {
	$cfg = Hash::Merge::Simple->merge($cfg, $c->{$i});
}
die 'missing config file' unless (keys %$cfg);

die 'missing some config parameters should be defined (irc_server, fb_app_id, fb_app_secret, fb_access_code, fb_page_id fb_postback_url)'
    if (!defined $cfg->{'fb_app_id'});

$cfg = Data::Recursive::Encode->decode('utf8', $cfg);

my $fb = Facebook::Graph->new(app_id   => $cfg->{'fb_app_id'},
			      secret   => $cfg->{'fb_app_secret'},
			      postback => $cfg->{'fb_postback_url'});
my $page_id = $cfg{'page_id'};

my $uri_t = $fb->authorize->extend_permissions(qw(offline_access publish_stream status_update))->uri_as_string;
print $uri_t . "\n";

print "\n\n↑この表示されてる uri をブラウザにつっこむと access_code が得られる redirect さきの url に code パラメタとしてくっついてくるので それを設定ファイルの access_code パラメータにコピペ...\n";
print "ただし そのブラウザで facebook にログインしている必要あり\n";

exit;
