#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#

use strict;
use utf8;

use Config::Any;
use Hash::Merge::Simple;
use Data::Recursive::Encode;

use FindBin;
use lib ("$FindBin::Bin/lib", '/usr/share/mubot4fb/lib');

use Mubot4FB::Config;

use AnyEvent::Twitter::Stream;

use Data::Dumper;

my $config_name = $ARGV[0] || 'not_found';

my $c = Mubot4FB::Config->new($config_name);
my $cfg = $c->{cfg};

die 'missing some config parameters should be defined (irc_server, fb_app_id, fb_app_secret, fb_access_code, fb_page_id fb_postback_url)'
  if (!defined $cfg->{'fb_app_id'}
      || !defined $cfg->{'fb_app_secret'}
      || !defined $cfg->{'fb_access_code'}
      || !defined $cfg->{'fb_page_id'}
      || !defined $cfg->{'fb_postback_url'}
      || !defined $cfg->{'twitter_consumer_key'}
      || !defined $cfg->{'twitter_consumer_secret'}
      || !defined $cfg->{'twitter_access_token'}
      || !defined $cfg->{'twitter_access_secret'}
      || !defined $cfg->{'db_user'}
      || !defined $cfg->{'db_pass'}
    );

my $mu = Mubot4FB->new($cfg);

my $done = AnyEvent->condvar;

my $listener = AnyEvent::Twitter::Stream->new(
      consumer_key    => $cfg->{'twitter_consumer_key'},
      consumer_secret => $cfg->{'twitter_consumer_secret'},
      token           => $cfg->{'twitter_access_token'},
      token_secret    => $cfg->{'twitter_access_secret'},
      method          => 'userstream',
      on_tweet        => sub {
	      my ($tweet) = @_;
	      print Dumper($tweet);
      },
  );

$done->recv;

1;
