#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::Worker;
use strict;
use utf8;

use Mubot4FB::Config;
use Mubot4FB::DB;
use Mubot4FB::Queue::Worker;

use Data::Dumper;

sub new {
	my ($proto, $config_name, $worker_name) = @_;
	my $class = ref $proto || $proto;
	my $self = {config_name => $config_name, worker_name => $worker_name};
	bless $self, $class;

	$self->init($config_name, $worker_name);
	return $self;
}

sub init {
	my ($me, $config_name, $worker_name) = @_;
	$me->{c} = Mubot4FB::Config->new($config_name);
	my $cfg = $me->{cfg} = $me->{c}->{cfg};
	$me->{db} = Mubot4FB::DB->new($me->{cfg});
	$me->{queue} = Mubot4FB::Queue::Worker->new($me->{cfg}, $me->{db}->{dbh}, {functions => [$worker_name]});
	$me->{worker_file} = $worker_name . '.pm';
	$me->{worker_file} =~ s/::/\//g;
	require($me->{worker_file});
	$me->{worker} = $worker_name->new($cfg);
	$me->{interval} = defined $me->{cfg}->{$worker_name}->{interval} ? $me->{cfg}->{$worker_name}->{interval} : 3;
	return $me;
}

sub run {
	my ($me) = @_;
	while (1) {
		my $job = $me->{queue}->dequeue;
		if ($me->{queue}->errstr) {
			warn $me->{queue}->errstr;
			sleep($me->{interval});
			next;
		}
		if ($job) {
			$me->{worker}->work($job);
		} else {
			sleep($me->{interval});
		}
	}
}

1;
