#include "mujikoma-common.h"
#include "Log.h"
#include "log/StdLog.h"

#include <cstdarg>
#include <dlfcn.h>

namespace MUJIKOMA_NAMESPACE {

using namespace log;

//
// Public
//

Log& Log::instance()
{
	static Log log;
	return log;
}

Log::~Log()
{
	if (lib) {
		if (mod) {
			destroy_t* destroy_mod
				= (destroy_t*)dlsym(lib, "destroy_StdLog");
			destroy_mod(mod);
			mod = 0;
		}
		dlclose(lib);
		lib = 0;
	}
}

void Log::log(level lv, const char* format, ...)
{
	if (!mod) {
		return;
	}

	va_list va;
	va_start(va, format);

	//StdLog std;
	//std.log(lv, format, va);
	mod->log(lv, format, va);

	va_end(va);
}

//
// Private
//

Log::Log()
: lib(0), mod(0)
{
	lib = dlopen("libStdLog.so", RTLD_LAZY);
	if (!lib) {
		return;
	}
	create_t* create_mod = (create_t*)dlsym(lib, "create_StdLog");
	if (!create_mod) {
		return;
	}
	mod = create_mod();
}

}

