#ifndef __MUJIKOMA_LOG_H__
#define __MUJIKOMA_LOG_H__

#include "mujikoma-common.h"

namespace MUJIKOMA_NAMESPACE {

using namespace std;

class LogModule;

class Log {
public:
	static Log& instance();
	~Log();

	typedef enum {
		LOG_ERR		= 3,
		LOG_WARNING	= 4,
		LOG_NOTICE	= 5,
		LOG_INFO	= 6,
		LOG_DEBUG	= 7,
	} level;
	void log(level lv, const char* format, ...);

private:
	void *lib;
	LogModule *mod;

	Log();
};

#define ELOG(fmt, ...) \
	Log::instance().log(Log::LOG_ERR, fmt "\n", ##__VA_ARGS__)
#define WLOG(fmt, ...) \
	Log::instance().log(Log::LOG_WARNING, fmt "\n", ##__VA_ARGS__)
#define NLOG(fmt, ...) \
	Log::instance().log(Log::LOG_NOTICE, fmt "\n", ##__VA_ARGS__)
#define ILOG(fmt, ...) \
	Log::instance().log(Log::LOG_INFO, fmt "\n", ##__VA_ARGS__)
#define DLOG(fmt, ...) \
	Log::instance().log(Log::LOG_DEBUG, fmt "\n", ##__VA_ARGS__)

#define ELOG_NB(fmt, ...) \
	Log::instance().log(Log::LOG_ERR, fmt, ##__VA_ARGS__)
#define WLOG_NB(fmt, ...) \
	Log::instance().log(Log::LOG_WARNING, fmt, ##__VA_ARGS__)
#define NLOG_NB(fmt, ...) \
	Log::instance().log(Log::LOG_NOTICE, fmt, ##__VA_ARGS__)
#define ILOG_NB(fmt, ...) \
	Log::instance().log(Log::LOG_INFO, fmt, ##__VA_ARGS__)
#define DLOG_NB(fmt, ...) \
	Log::instance().log(Log::LOG_DEBUG, fmt, ##__VA_ARGS__)

}

#endif // __MUJIKOMA_LOG_H__

