#include "mujikoma-common.h"
#include "MujiKoma.h"

#include <signal.h>

using namespace MUJIKOMA_NAMESPACE;

static MujiKoma *koma = NULL;

void sig_trap(int signo)
{
	printf("### signo %d\n", signo);
	if (koma) {
		koma->stop();
	}
}

void init_sig()
{
	struct sigaction sa;

	memset(&sa, 0x0, sizeof(struct sigaction));
	sa.sa_handler = sig_trap;
	sa.sa_flags = SA_NOCLDWAIT | SA_NOCLDSTOP;

	if (sigaction(SIGINT, &sa, NULL)) {
		perror("sigaction");
	}
	if (sigaction(SIGTERM, &sa, NULL)) {
		perror("sigaction");
	}
	if (sigaction(SIGHUP, &sa, NULL)) {
		perror("sigaction");
	}
	return;
}

int main(int argc, char** argv)
{
	int ret;

	printf("MujiKoma start\n");

	init_sig();

	if (argc == 1) {
		printf("Daemonized...\n");
		ret = daemon(1, 1);
		if (ret) {
			perror("daemon");
			return ret;
		}
	}

	printf("pid %d\n", getpid());

	koma = new MujiKoma();
	koma->start();
	delete koma;

	return 0;
}

