<?php
/**
 * @package user
 * @version $Id: UserEditAction.class.php,v 1.2 2007/12/22 17:54:05 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserAdminEditForm.class.php";

class User_UserEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return XCube_Root::getSingleton()->mContext->mRequest->getRequest('uid');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_UserAdminEditForm();
		$this->mActionForm->prepare();
	}

	function _setupObject()
	{
		$id = $this->_getId();
		
		$this->mObjectHandler = $this->_getHandler();
		
		$this->mObject =& $this->mObjectHandler->get($id);
		
		if ($this->mObject == null && $this->isEnableCreate()) {
			$root =& XCube_Root::getSingleton();
			$this->mObject =& $this->mObjectHandler->create();
			$this->mObject->set('timezone_offset', $root->mContext->getXoopsConfig('server_TZ'));
		}
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_edit.html");
		$render->setAttribute("actionForm", $this->mActionForm);

		//
		// Get some objects for input form.
		//
		$tzoneHandler =& xoops_gethandler('timezone');
		$timezones =& $tzoneHandler->getObjects();
		
		$render->setAttribute('timezones', $timezones);

		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		
		$groupOptions = array();
		foreach ($groups as $gid => $group) {
			$groupOptions[$gid] = $group->getVar('name');
		}

		$render->setAttribute('groupOptions', $groupOptions);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=UserList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("index.php", 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=UserList");
	}
}

?>