<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once XOOPS_ROOT_PATH . '/core/XCube_PageNavigator.class.php';

/**
 * Sd2nd_AbstractListAction
**/
abstract class Sd2nd_AbstractListAction extends Sd2nd_AbstractAction
{
    /**
     * @brief   XoopsSimpleObject[]
    **/
    public $mObjects = null;

    /**
     * @brief   Sd2nd_AbstractFilterForm
    **/
    public $mFilter = null;

    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  &XoopsObjectGenericHandler
    **/
    protected function &_getHandler()
    {
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  &Sd2ndAbstractFilterForm
    **/
    protected function &_getFilterForm()
    {
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
    }

    /**
     * &_getPageNavi
     * 
     * @param   void
     * 
     * @return  &XCube_PageNavigator
    **/
    protected function &_getPageNavi()
    {
        $navi = new XCube_PageNavigator($this->_getBaseUrl(), XCUBE_PAGENAVI_START);
        return $navi;
    }

    /**
     * getDefaultView
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getDefaultView()
    {
        $this->mFilter =& $this->_getFilterForm();
        $this->mFilter->fetch();
    
        $handler =& $this->_getHandler();
        $this->mObjects =& $handler->getObjects($this->mFilter->getCriteria());
    
        return SD2ND_FRAME_VIEW_INDEX;
    }

    /**
     * execute
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function execute()
    {
        return $this->getDefaultView();
    }
}


/**
 * @class   Sd2nd_AbstractUpdateListAction
**/
class Sd2nd_AbstractUpdateListAction extends Sd2nd_AbstractListAction
{
    /**
     * @brief   Sd2nd_UpdateHandler
    **/
    protected $_mUpdateHandler = null;
    
    /**
     * prepare
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function prepare()
    {
        if(!parent::prepare())
        {
            return false;
        }
        
        $this->_mUpdateHandler =& $this->mAsset->getObject('handler',Sd2nd_AssetManager::HANDLER_UPDATE);
        if(!isset($_GET['regist_time']))
        {
            $update =& $this->_mUpdateHandler->getLatestUpdate();
            $_GET['regist_time'] = $update->get('update_time');
        }
        
        return true;
    }
}

?>
