<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_AbilityObject
**/
class Sd2nd_AbilityObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('ability_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('ability_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('description', XOBJ_DTYPE_STRING, '', false, 255);
        $this->initVar('ability_cost', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_AbilityHandler
**/
class Sd2nd_AbilityHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_ability';

    /**
     * @brief   string
    **/
    public $mPrimary = 'ability_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_AbilityObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
