<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_EnoPnoLinkObject
**/
class Sd2nd_EnoPnoLinkObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('pno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_EnoPnoLinkHandler
**/
class Sd2nd_EnoPnoLinkHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_eno_pno_link';

    /**
     * @brief   string
    **/
    public $mPrimary = 'eno';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_EnoPnoLinkObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
