<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_TargetObject
**/
class Sd2nd_TargetObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('target_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('target_name', XOBJ_DTYPE_STRING, '', false, 10);
        $this->initVar('point', XOBJ_DTYPE_STRING, '', false, 40);
    }
}

/**
 * Sd2nd_TargetHandler
**/
class Sd2nd_TargetHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_target';

    /**
     * @brief   string
    **/
    public $mPrimary = 'target_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_TargetObject';

    /**
     * @brief   Sd2nd_TargetObject{}
    **/
    protected $_mConvertTable = null;

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * _setupConvertTable
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _setupConvertTable()
    {
        if($this->_mConvertTable == null)
        {
            $cri = new CriteriaCompo();
            $cri->setSort('target_name','ASC');
            $this->_mConvertTable =& $this->getObjects($cri,null,null,true);
        }
    }
    
    /**
     * getList
     * 
     * @param   void
     * 
     * @return  Sd2nd_TargetObject{}
    **/
    public function getList()
    {
        $this->_setupConvertTable();
        return $this->_mConvertTable;
    }
    
    /**
     * convertToView
     * 
     * @param   int $key
     * 
     * @return  string
    **/
    public function convertToView(/*** int ***/ $key)
    {
        $this->_setupConvertTable();
        return isset($this->_mConvertTable[$key]) ? $this->_mConvertTable[$key]->getShow('target_name') : null;
    }
}

?>
