<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_ChardataExecute
**/
class Sd2nd_ChardataExecute extends Sd2nd_AbstractExecute
{
    public /*** XoopsSimpleObject{} ***/ $mCharData = array(
        Sd2nd_AssetManager::HANDLER_CHAR => null,
        Sd2nd_AssetManager::HANDLER_STATUS => null
    );
    public /*** XoopsSimpleObject{}[] ***/ $mCharDataList = array(
        Sd2nd_AssetManager::HANDLER_ICON => array(),
        Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY => array(),
        Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME => array(),
        Sd2nd_AssetManager::HANDLER_LEARNED_SKILL => array()
    );
    public /*** string ***/ $mActiveCostume = null;
    public /*** string{} ***/ $mActiveAbilities = array();
    public /*** string{}[] ***/ $mWeaponLv = array();
    public /*** Sd2nd_ImageObject ***/ $mImage = null;
    public /*** int{} ***/ $mSpots = array();
    public /*** int[] ***/ $mMaps = array();
    public /*** int{} ***/ $mPoint = array('x' => 0,'y' => 0);
    protected /*** string ***/ $_mParserPath = 'execute/parser/charParser';
    protected /*** string ***/ $_mFilterPattern = '/^(?P<name>\w+)[\(\[]/';
    protected /*** XCube_HttpContext ***/ $_mContext = null;
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return   void
    **/
    public function __construct()
    {
        parent::__construct();
        
        $root =& XCube_Root::getSingleton();
        $this->_mContext =& $root->mContext;
    }
    
    /**
     * reset
     * 
     * @param   int     $id
     * @param   string  $text
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id,/*** string ***/ $text)
    {
        parent::reset($id,$text);
        
        foreach(array_keys($this->mCharData) as $type)
        {
            $this->mCharData[$type] =& Sd2nd_UpdateUtils::createObject($type);
            $this->mCharData[$type]->set('eno',$id);
        }
        
        foreach(array_keys($this->mCharDataList) as $type)
        {
            $this->mCharDataList[$type] = array();
        }

        $this->mActiveCostume = null;
        $this->mActiveAbilities = array();
        $this->mWeaponLv = array();
        $this->mImage = null;
        $this->mSpots = array();
        $this->mMaps = array();
        $this->mPoint = array('x' => 0,'y' => 0);
    }
    
    /**
     * _save
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    protected function _save()
    {
        foreach(array_keys($this->mCharData) as $type)
        {
            if($this->mCharData[$type] instanceof XoopsSimpleObject)
            {
                Sd2nd_UpdateUtils::insertObject($type,$this->mCharData[$type]);
            }
        }
        
        foreach(array_keys($this->mCharDataList) as $type)
        {
            foreach(array_keys($this->mCharDataList[$type]) as $key)
            {
                Sd2nd_UpdateUtils::insertObject($type,$this->mCharDataList[$type][$key]);
            }
        }
        
        foreach($this->mActiveAbilities as $key => $abilityName)
        {
            $ability =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_ACTIVE_ABILITY);
            $ability->setVars(array('eno' => $this->_mActiveId,'slot' => $key,'ability_id' => $this->_mContext->mAttributes['sd2nd.ability'][$abilityName]));
            Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_ACTIVE_ABILITY,$ability);
        }
        
        foreach(array_keys($this->mWeaponLv) as $key)
        {
        }
        
        if($this->mImage instanceof Sd2nd_ImageObject)
        {
            Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_IMAGE,$this->mImage);
        }
    }
}


?>
