<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Costume_DataCharParser
**/
class Sd2nd_Costume_DataCharParser extends Sd2nd_AbstractParser
{
    protected /*** mixed{} ***/ $_mAttrs =null;
    protected /*** XoopsDatabase ***/ $_mDB = null;
    protected /*** int{} ***/ $_mLearnedCostume = array();
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  voud
    **/
    public function __construct()
    {
        parent::__construct();
        
        $root =& XCube_Root::getSingleton();
        $this->_mAttrs =& $root->mContext->mAttributes;
        $this->_mDB =& $root->mController->mDB;
    }
    
    /**
     * reset
     * 
     * @param   int                     $id
     * @param   Sd2nd_AbstractExecute   &$execute
     * @param   string                  $line
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    public function reset(/*** int ***/ $id,Sd2nd_AbstractExecute &$execute,/*** string ***/ $line)
    {
        parent::reset($id,$execute,$line);
        
        $this->_mLearnedCostume = array();
        if(!$res = $this->_mDB->query('select `costume_id`,`costume_lv`,`costume_point` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME) . '` where `eno` = ' . intval($this->_mActiveId)))
        {
            throw new Sd2nd_QueryException('LearnedCostume data is not readable.');
        }
        
        while($row = $this->_mDB->fetchArray($res))
        {
            $this->_mLearnedCostume[$row['costume_id']] = array('costume_lv' => $row['costume_lv'],'costume_point' => $row['costume_point']);
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByExplode($this->_mLine,22,strpos($this->_mLine,'(') + 1,-1,array('costume_id','costume_name','costume_lv','costume_exp','costume_point','grow_life','grow_soul','grow_pow','grow_str','grow_dex','grow_speed','grow_mag','grow_reg','grow_con','modify_hp','modify_tp','modify_at','modify_df','modify_mat','modify_mdf','modify_act','move_cost'));
        $arr['costume_name'] = trim($arr['costume_name'],"'");
        if(!isset($this->_mAttrs['sd2nd.costume'][$arr['costume_name']]))
        {
            $this->_appendCostume($arr);
        }
        if(!isset($this->_mLearnedCostume[$arr['costume_id']]) || $this->_mLearnedCostume[$arr['costume_id']]['costume_lv'] != $arr['costume_lv'] || $this->_mLearnedCostume[$arr['costume_id']]['costume_point'] != $arr['costume_point'])
        {
            $this->_appendLearnedCostume($arr['costume_id'],$arr['costume_lv'],$arr['costume_point']);
        }
    }
    
    /**
     * _appendCostume
     * 
     * @param   mixed{} $params
     * 
     * @return  void
    **/
    protected function _appendCostume(/*** mixed{} ***/ $params)
    {
        $this->_mAttrs['sd2nd.costume'][$params['costume_name']] = $params['costume_id'];
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_COSTUME);
        unset($params['costume_lv'],$params['costume_exp'],$params['costume_point']);
        $obj->setVars($params);
        $obj->set('regist_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_COSTUME,$obj);
    }
    
    /**
     * _appendLearnedCostume
     * 
     * @param   int $id
     * @param   int $lv
     * @param   int $point
     * 
     * @return  void
    **/
    protected function _appendLearnedCostume(/*** int ***/ $id,/*** int ***/ $lv,/*** int ***/ $point)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME);
        $obj->set('eno',$this->_mActiveId);
        $obj->set('costume_id',$id);
        $obj->set('costume_lv',$lv);
        $obj->set('costume_point',$point);
        $obj->set('regist_time',$this->_mUpdateTime);
        if(isset($this->_mLearnedCostume[$id]))
        {
            $obj->unsetNew();
        }
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_LEARNED_COSTUME,$obj);
    }
}


?>
