<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Map_DataCharParser
**/
class Sd2nd_Map_DataCharParser extends Sd2nd_AbstractParser
{
    protected /*** int{} ***/ $_mSpot = null;
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  voud
    **/
    public function __construct()
    {
        parent::__construct();
        $this->_mSpot =& XCube_Root::getSingleton()->mContext->mAttributes['sd2nd.spot'];
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,"/\[(?P<id>\d+)\] = new TableData_Set\('#[\dA-F]{6}','(?P<spot_name>[^']+)'\)/");
        $arr['spot_name'] = trim($arr['spot_name'],"'");
        $arr['regist_time'] = $this->_mUpdateTime;
        
        if(!isset($this->_mSpot[$arr['spot_name']]))
        {
            $spot =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_MAP_SPOT);
            $spot->setVars($arr);
            Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_MAP_SPOT,$spot);
            $this->_mSpot[$arr['spot_name']] = $spot->get('spot_id');
        }
        
        $this->_mExecute->mSpots[$arr['id']] = $this->_mSpot[$arr['spot_name']];
    }
}


?>
