<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_WSkill_DataCharParser
**/
class Sd2nd_WSkill_DataCharParser extends Sd2nd_AbstractParser
{
    protected /*** mixed{} ***/ $_mAttributes = null;
    protected /*** XoopsDatabase ***/ $_mDB = null;
    protected /*** int{} ***/ $_mLearnedSkill = array();
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  voud
    **/
    public function __construct()
    {
        parent::__construct();
        
        $root =& XCube_Root::getSingleton();
        $this->_mAttributes =& $root->mContext->mAttributes;
        $this->_mDB =& $root->mController->mDB;
    }
    
    /**
     * reset
     * 
     * @param   int                     $id
     * @param   Sd2nd_AbstractExecute   &$execute
     * @param   string                  $line
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id,Sd2nd_AbstractExecute &$execute,/*** string ***/ $line)
    {
        parent::reset($id,$execute,$line);
        
        $this->_mLearnedSkill = array();
        if(!$res = $this->_mDB->query('select `skill_id` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_LEARNED_SKILL) . '` where `eno` = ' . intval($this->_mActiveId)))
        {
            throw new Sd2nd_QueryException('LearnedSkill data is not readable.');
        }
        
        while($row = $this->_mDB->fetchArray($res))
        {
            $this->_mLearnedSkill[$row['skill_id']] = $row['skill_id'];
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,"/TableData_Set\((?P<skill_id>\d+),'(?P<skill_name>[^']+)','(?P<description>[^']*)',(?P<range>[^,]+),'(?P<target>[^']+)',(?P<point>'?[\d,]+'?),(?P<element>'?[\-\d,]+'?),'(?P<kind>[^']+)',(?P<tp>\d+)\)/");
        if(!isset($this->_mLearnedSkill[$arr['skill_id']]))
        {
            $this->_registLearnedSkill($arr);
        }
    }
    
    /**
     * _registLearnedSkill
     * 
     * @param   mixed{} $param
     * 
     * @return  void
    **/
    protected function _registLearnedSkill(/*** mixed{} ***/ $param)
    {
        if(!isset($this->_mAttributes['sd2nd.skill'][$param['skill_name']]))
        {
            $this->_registSkill($param);
        }
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_LEARNED_SKILL);
        $obj->setVars(array('eno' => $this->_mActiveId,'skill_id' => $param['skill_id'],'regist_time' => $this->_mUpdateTime));
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_LEARNED_SKILL,$obj);
    }
    
    /**
     * _registSkill
     * 
     * @param   mixed{} $param
     * 
     * @return  void
    **/
    protected function _registSkill(/*** mixed{} ***/ $param)
    {
        if(!isset($this->_mAttributes['sd2nd.target'][$param['target']]))
        {
            $this->_registTarget($param['target'],trim($param['point'],"'"));
        }
        if(!isset($this->_mAttributes['sd2nd.kind'][$param['kind']]))
        {
            $this->_registKind($param['kind']);
        }
        $this->_mAttributes['sd2nd.skill'][$param['skill_name']] = $param['skill_id'];
        $skill =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_SKILL);
        $skill->set('skill_id',$param['skill_id']);
        $skill->set('skill_name',$param['skill_name']);
        $skill->set('description',strtr($param['description'],array('<br>' => "\n")));
        $skill->set('range',$param['range'] * 10);
        $skill->set('target',$this->_mAttributes['sd2nd.target'][$param['target']]);
        $skill->set('kind',$this->_mAttributes['sd2nd.kind'][$param['kind']]);
        $skill->set('tp',$param['tp']);
        $skill->set('regist_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_SKILL,$skill);
        $this->_registSkillElement($param['skill_id'],explode(',',$param['element']));
    }
    
    /**
     * _registTarget
     * 
     * @param   string  $target
     * @param   string  $point
     * 
     * @return  void
    **/
    protected function _registTarget(/*** string ***/ $target,/*** string ***/ $point)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_TARGET);
        $obj->set('target_name',$target);
        $obj->set('point',$point);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_TARGET,$obj);
        $this->_mAttributes['sd2nd.target'][$target] = $obj->get('target_id');
    }
    
    /**
     * _registKind
     * 
     * @param   string  $kind
     * 
     * @return  void
    **/
    protected function _registKind(/*** string ***/ $kind)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_KIND);
        $obj->set('kind_name',$kind);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_KIND,$obj);
        $this->_mAttributes['sd2nd.kind'][$kind] = $obj->get('kind_id');
    }
    
    /**
     * _registSkillElement
     * 
     * @param   int     $id
     * @param   int[]   $elements
     * 
     * @return  void
    **/
    protected function _registSkillElement(/*** int ***/ $id,/*** int[] ***/ $elements)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK);
        $obj->set('skill_id',$id);
        foreach($elements as $e)
        {
            $obj->set('element',$e);
            Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,$obj);
        }
    }
}


?>
