<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_CostumeListPrepare
**/
class Sd2nd_CostumeListPrepare extends Sd2nd_AbstractFilter
{
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        $arr = array();
        
        if(!$res = $db->query('select `costume_id`,`costume_name` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_COSTUME) . '`'))
        {
            throw new Sd2nd_QueryException('Costume data is not readable.');
        }
        
        while($row = $db->fetchArray($res))
        {
            $arr[$row['costume_name']] = $row['costume_id'];
        }
        
        $root->mContext->setAttribute('sd2nd.costume',$arr);
    }
}

?>
