<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_TargetListPrepare
**/
class Sd2nd_TargetListPrepare extends Sd2nd_AbstractFilter
{
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        $arr = array();
        
        if(!$res = $db->query('select `target_id`,`target_name` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_TARGET) . '`'))
        {
            throw new Sd2nd_QueryException('Target data is not readable.');
        }
        
        while($row = $db->fetchArray($res))
        {
            $arr[$row['target_name']] = $row['target_id'];
        }
        
        $root->mContext->setAttribute('sd2nd.target',$arr);
    }
}

?>
