<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

if(!defined('SD2ND_TRUST_PATH'))
{
    define('SD2ND_TRUST_PATH',XOOPS_TRUST_PATH . '/modules/sd2nd');
}

require_once SD2ND_TRUST_PATH . '/class/Sd2ndUtils.class.php';

Sd2nd_AssetPreloadBase::prepare();


/**
 * Sd2nd_AssetPreloadBase
**/
class Sd2nd_AssetPreloadBase extends XCube_ActionFilter
{
    /**
     * prepare
     * 
     * @param   void
     * 
     * @return  void
    **/
    public static function prepare()
    {
        $root =& XCube_Root::getSingleton();
        $instance = new Sd2nd_AssetPreloadBase($root->mController);
        $root->mController->addActionFilter($instance);
    }

    /**
     * preBlockFilter
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function preBlockFilter()
    {
        $this->mRoot->mDelegateManager->add('Module.sd2nd.Global.Event.GetAssetManager','Sd2nd_AssetPreloadBase::getManager');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateModule','Sd2nd_AssetPreloadBase::getModule');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateBlockProcedure','Sd2nd_AssetPreloadBase::getBlock');
    }

    /**
     * getManager
     * 
     * @param   Sd2nd_AssetManager  &$obj
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public static function getManager(/*** Sd2nd_AssetManager ***/ &$obj,/*** string ***/ $dirname)
    {
        require_once SD2ND_TRUST_PATH . '/class/AssetManager.class.php';
        $obj = Sd2nd_AssetManager::getInstance($dirname);
    }

    /**
     * getModule
     * 
     * @param   Legacy_AbstractModule  &$obj
     * @param   XoopsModule  $module
     * 
     * @return  void
    **/
    public static function getModule(/*** Legacy_AbstractModule ***/ &$obj,/*** XoopsModule ***/ $module)
    {
        if($module->getInfo('trust_dirname') == 'sd2nd')
        {
            require_once SD2ND_TRUST_PATH . '/class/Module.class.php';
            $obj = new Sd2nd_Module($module);
        }
    }

    /**
     * getBlock
     * 
     * @param   Legacy_AbstractBlockProcedure  &$obj
     * @param   XoopsBlock  $block
     * 
     * @return  void
    **/
    public static function getBlock(/*** Legacy_AbstractBlockProcedure ***/ &$obj,/*** XoopsBlock ***/ $block)
    {
        $moduleHandler =& Sd2nd_Utils::getXoopsHandler('module');
        $module =& $moduleHandler->get($block->get('mid'));
        if(is_object($module) && $module->getInfo('trust_dirname') == 'sd2nd')
        {
            require_once SD2ND_TRUST_PATH . '/blocks/' . $block->get('func_file');
            $className = 'Sd2nd_' . substr($block->get('show_func'), 4);
            $obj = new $className($block);
        }
    }
}

?>
