CREATE TABLE `{prefix}_{dirname}_ability` (
  `ability_id` smallint(5) unsigned NOT NULL,
  `ability_name` varchar(50) NOT NULL,
  `description` varchar(255) NOT NULL,
  `ability_cost` tinyint(4) NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`ability_id`),
  UNIQUE KEY `ability_name` (`ability_name`),
  KEY `regist_time` (`regist_time`,`ability_id`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_active_ability` (
  `eno` smallint(5) unsigned NOT NULL,
  `slot` tinyint(3) unsigned NOT NULL,
  `ability_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`ability_id`,`eno`),
  UNIQUE KEY `eno` (`eno`,`slot`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_char` (
  `eno` smallint(5) unsigned NOT NULL,
  `full_name` varchar(40) NOT NULL,
  `nick_name` varchar(16) NOT NULL,
  `battle_name` varchar(16) NOT NULL,
  `sex` tinyint(3) unsigned NOT NULL,
  `age` smallint(5) unsigned NOT NULL,
  `height` smallint(5) unsigned NOT NULL,
  `weight` smallint(5) unsigned NOT NULL,
  `profile` text NOT NULL,
  `race` tinyint(3) unsigned NOT NULL,
  `element_base` tinyint(3) unsigned NOT NULL,
  `element_ext` tinyint(3) unsigned NOT NULL,
  `active_costume` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_costume` (
  `costume_id` smallint(5) unsigned NOT NULL,
  `costume_name` varchar(50) NOT NULL,
  `grow_life` tinyint(4) NOT NULL,
  `grow_soul` tinyint(4) NOT NULL,
  `grow_pow` tinyint(4) NOT NULL,
  `grow_str` tinyint(4) NOT NULL,
  `grow_dex` tinyint(4) NOT NULL,
  `grow_speed` tinyint(4) NOT NULL,
  `grow_mag` tinyint(4) NOT NULL,
  `grow_reg` tinyint(4) NOT NULL,
  `grow_con` tinyint(4) NOT NULL,
  `modify_hp` tinyint(4) NOT NULL,
  `modify_tp` tinyint(4) NOT NULL,
  `modify_at` tinyint(4) NOT NULL,
  `modify_df` tinyint(4) NOT NULL,
  `modify_mat` tinyint(4) NOT NULL,
  `modify_mdf` tinyint(4) NOT NULL,
  `modify_act` tinyint(4) NOT NULL,
  `move_cost` tinyint(3) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`costume_id`),
  KEY `regist_time` (`regist_time`,`costume_id`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_eno_pno_link` (
  `eno` smallint(5) unsigned NOT NULL,
  `pno` smallint(5) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`eno`,`regist_time`),
  KEY `pno` (`pno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_icon` (
  `icon_id` smallint(5) unsigned NOT NULL auto_increment,
  `eno` smallint(5) unsigned NOT NULL,
  `slot` tinyint(3) unsigned NOT NULL,
  `icon_url` varchar(255) NOT NULL,
  `icon_height` tinyint(3) unsigned NOT NULL,
  `icon_width` tinyint(3) unsigned NOT NULL,
  `update_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`icon_id`),
  UNIQUE KEY `eno` (`eno`,`slot`,`update_time`),
  KEY `update_time` (`update_time`,`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_image` (
  `image_id` smallint(5) unsigned NOT NULL auto_increment,
  `eno` smallint(5) unsigned NOT NULL,
  `image_url` varchar(255) NOT NULL,
  `image_height` smallint(5) unsigned NOT NULL,
  `image_width` smallint(5) unsigned NOT NULL,
  `image_link` varchar(255) NOT NULL,
  `update_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`image_id`),
  UNIQUE KEY `eno` (`eno`,`update_time`),
  KEY `update_time` (`update_time`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_kind` (
  `kind_id` tinyint(3) unsigned NOT NULL auto_increment,
  `kind_name` varchar(20) NOT NULL,
  `kind_kind` tinyint(3) unsigned NOT NULL,
  `weight` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY  (`kind_id`),
  UNIQUE KEY `kind_name` (`kind_name`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_learned_ability` (
  `eno` smallint(5) unsigned NOT NULL,
  `ability_id` smallint(5) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`eno`,`ability_id`),
  KEY `ability_id` (`ability_id`),
  KEY `regist_time` (`regist_time`,`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_learned_costume` (
  `eno` smallint(5) unsigned NOT NULL,
  `costume_id` smallint(5) unsigned NOT NULL,
  `costume_lv` tinyint(3) unsigned NOT NULL,
  `costume_point` tinyint(3) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`eno`,`costume_id`),
  KEY `costume_id` (`costume_id`),
  KEY `regist_time` (`regist_time`,`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_learned_skill` (
  `eno` smallint(5) unsigned NOT NULL,
  `skill_id` smallint(5) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`eno`,`skill_id`),
  KEY `skill_id` (`skill_id`),
  KEY `regist_time` (`regist_time`,`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_map` (
  `map_id` tinyint(3) unsigned NOT NULL,
  `x` tinyint(4) NOT NULL,
  `y` tinyint(4) NOT NULL,
  `spot_id` tinyint(3) unsigned NOT NULL,
  `update_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`map_id`,`x`,`y`,`update_time`),
  KEY `spot_id` (`spot_id`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_map_cache` (
  `map_id` tinyint(3) unsigned NOT NULL,
  `update_time` int(10) unsigned NOT NULL,
  `map_range` varchar(255) NOT NULL,
  `map_body` text NOT NULL,
  PRIMARY KEY  (`map_id`,`update_time`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_map_name` (
  `map_id` tinyint(3) unsigned NOT NULL,
  `map_name` varchar(50) NOT NULL,
  `base_spot` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY  (`map_id`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_map_spot` (
  `spot_id` tinyint(3) unsigned NOT NULL auto_increment,
  `spot_name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`spot_id`),
  UNIQUE KEY `spot_name` (`spot_name`),
  KEY `regist_time` (`regist_time`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_race` (
  `race_id` tinyint(4) unsigned NOT NULL auto_increment,
  `race_name` varchar(50) NOT NULL,
  PRIMARY KEY  (`race_id`),
  UNIQUE KEY `race_name` (`race_name`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_skill` (
  `skill_id` smallint(5) unsigned NOT NULL,
  `skill_name` varchar(50) NOT NULL,
  `description` varchar(255) default NULL,
  `range` tinyint(3) unsigned NOT NULL,
  `target` tinyint(3) unsigned NOT NULL,
  `kind` tinyint(3) unsigned NOT NULL,
  `tp` smallint(5) unsigned NOT NULL,
  `regist_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`skill_id`),
  KEY `kind` (`kind`,`tp`),
  KEY `regist_time` (`regist_time`,`kind`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_skill_element_link` (
  `skill_id` smallint(5) unsigned NOT NULL,
  `element` tinyint(4) NOT NULL,
  PRIMARY KEY  (`skill_id`,`element`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_status` (
  `eno` smallint(5) unsigned NOT NULL,
  `lv` tinyint(3) unsigned NOT NULL,
  `life` smallint(5) unsigned NOT NULL,
  `soul` smallint(5) unsigned NOT NULL,
  `pow` smallint(5) unsigned NOT NULL,
  `str` smallint(5) unsigned NOT NULL,
  `dex` smallint(5) unsigned NOT NULL,
  `speed` smallint(5) unsigned NOT NULL,
  `mag` smallint(5) unsigned NOT NULL,
  `reg` smallint(5) unsigned NOT NULL,
  `con` smallint(5) unsigned NOT NULL,
  `exp` smallint(5) unsigned NOT NULL,
  `money` smallint(5) unsigned NOT NULL,
  `sp` smallint(5) unsigned NOT NULL,
  `base_hp` smallint(5) unsigned NOT NULL,
  `base_at` smallint(5) unsigned NOT NULL,
  `base_df` smallint(5) unsigned NOT NULL,
  `base_mat` smallint(5) unsigned NOT NULL,
  `base_mdf` smallint(5) unsigned NOT NULL,
  `base_act` smallint(5) unsigned NOT NULL,
  `base_move` smallint(5) unsigned NOT NULL,
  `modify_hp` smallint(6) NOT NULL,
  `modify_at` smallint(6) NOT NULL,
  `modify_df` smallint(6) NOT NULL,
  `modify_mat` smallint(6) NOT NULL,
  `modify_mdf` smallint(6) NOT NULL,
  `modify_act` smallint(6) NOT NULL,
  `modify_move` smallint(6) NOT NULL,
  `equip_hp` smallint(6) NOT NULL,
  `equip_at` smallint(6) NOT NULL,
  `equip_df` smallint(6) NOT NULL,
  `equip_mat` smallint(6) NOT NULL,
  `equip_mdf` smallint(6) NOT NULL,
  `equip_act` smallint(6) NOT NULL,
  `equip_move` smallint(6) NOT NULL,
  PRIMARY KEY  (`eno`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_target` (
  `target_id` tinyint(3) unsigned NOT NULL auto_increment,
  `target_name` varchar(10) NOT NULL,
  `point` varchar(40) NOT NULL,
  PRIMARY KEY  (`target_id`),
  UNIQUE KEY `target_name` (`target_name`)
) ENGINE=MyISAM;

CREATE TABLE `{prefix}_{dirname}_update` (
  `update_time` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`update_time`)
) ENGINE=MyISAM;
