<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD3RD_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd3rd_SkillListAction
**/
class Sd3rd_SkillListAction extends Sd3rd_AbstractListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd3rd_SkillHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'Skill');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd3rd_SkillFilterForm
    **/
    protected function &_getFilterForm()
    {
        $filter =& $this->mAsset->getObject('filter', 'Skill',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=SkillList';
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_skill_list.html');
        #cubson::lazy_load_array('skill', $this->mObjects);
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
        $render->setAttribute('linkHandler',$this->mAsset->getObject('handler','SkillElement'));
        $render->setAttribute('elementHandler',$this->_getMasterHandler('Element'));
        $render->setAttribute('targetHandler',$this->_getMasterHandler('Target'));
        $render->setAttribute('kindHandler',$this->_getMasterHandler('Kind'));
        $render->setAttribute('updateHandler',$this->mAsset->getObject('handler','Update'));
    }
}

?>
