<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Base of master data handler.
**/
abstract class Sd3rd_AbstractMasterHandler extends XoopsObjectGenericHandler
{
    protected /*** string ***/ $_mCache = array();
    protected /*** bool ***/ $_mCanCreate = true;
    protected /*** string ***/ $_mIdColumn = null;
    protected /*** string ***/ $_mValueColumn = null;
    
    /**
     * Constructor of this class.
     * 
     * @param   XoopsDatabase   &$db
     * @param   string          $dirname
     * 
     * @return  void
    **/
    public function __construct(XoopsDatabase &$db,/*** string ***/ $dirname)
    {
        $this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
        parent::__construct($db);
    }
    
    /**
     * Setup master data cache.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function setupMaster()
    {
        foreach($this->getObjects() as $obj)
        {
            $this->_mCache[$obj->get($this->_mValueColumn)] = $obj->get($this->_mIdColumn);
        }
    }
    
    /**
     * Convert master value to id.
     * 
     * @param   mixed   $value
     * @param   mixed{} $extra
     * @param   bool    $force
     * 
     * @return  int
    **/
    public function getId(/*** mixed ***/ $value,/*** mixed{} ***/ $extra = array(),/*** bool ***/ $force = false)
    {
        if(!isset($this->_mCache[$value]))
        {
            if($this->_mCanCreate)
            {
                $extra[$this->_mValueColumn] = $value;
                $this->_appendMaster($extra,$force);
            }
            else
            {
                throw new Sd3rd_ErrorException('Cannot get master id.');
            }
        }
        return $this->_mCache[$value];
    }
    
    /**
     * Create new record at master data.
     * 
     * @param   mixed{} $values
     * @param   bool    $force
     * 
     * @return  void
    **/
    protected function _appendMaster(/*** mixed{} ***/ $values,/*** bool ***/ $force)
    {
        $obj =& $this->create();
        $obj->setVars($values);
        if(!$this->insert($obj,$force))
        {
            throw new Sd3rd_QueryErrorException('Cannot insert master data.');
        }
        $this->_mCache[$obj->get($this->_mValueColumn)] = $obj->get($this->_mIdColumn);
    }
    
    /**
     * Setup master item list.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function setupList()
    {
        foreach($this->getObjects($this->_makeDefaultCriteria()) as $obj)
        {
            $this->_mCache[$obj->get($this->_mIdColumn)] = $obj;
        }
    }
    
    /**
     * Create CriteriaElement instance for list.
     * 
     * @param   void
     * 
     * @return  CriteriaElement
    **/
    protected function _makeDefaultCriteria()
    {
        $cri = new CriteriaCompo();
        $cri->addSort($this->_mValueColumn,'ASC');
        $cri->addSort($this->_mIdColumn,'ASC');
        return $cri;
    }
    
    /**
     * Get master item list.
     * 
     * @param   void
     * 
     * @return  XoopsSimpleObject{}
    **/
    public function getList()
    {
        return $this->_mCache;
    }
    
    /**
     * Convert from id to value.
     * 
     * @param   mixed   $id
     * 
     * @return  mixed
    **/
    public function convertToMaster(/*** mixed ***/ $id)
    {
        return isset($this->_mCache[$id]) ? $this->_mCache[$id]->getShow($this->_mValueColumn) : null;
    }
}

?>
