<?php
/**
 * @file
 * @package 
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Base of extended exception.
**/
class Sd3rd_Exception extends Exception
{
    protected /*** mixed{} ***/ $_mParams = array();
    
    /**
     * Constructor of this class.
     * 
     * @param   string  $message
     * @param   mixed{} $params
     * 
     * @return  void
    **/
    public function __construct(/*** string ***/ $message,/*** mixed{} ***/ $params = array())
    {
        parent::__construct($message);
        foreach($params as $key => $value)
        {
            $this->set($key,$value);
        }
    }
    
    /**
     * Get extra parameter.
     * 
     * @param   string  $key
     * 
     * @return  mixed
    **/
    public function get(/*** string ***/ $key)
    {
        return isset($this->_mParams[$key]) ? $this->_mParams[$key] : null;
    }
    
    /**
     * Set extra parameter.
     * 
     * @param   string  $key
     * @param   mixed   $value
     * 
     * @return  void
    **/
    public function set(/*** string ***/ $key,/*** mixed ***/ $value)
    {
        $this->_mParams[$key] = $value;
    }
    
    /**
     * Is fatal exception ?
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function isFatal()
    {
        return true;
    }
    
    /**
     * Get information of this exception.
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function __toString()
    {
        return print_r($this,true);
    }
}

#region not found exception
/**
 * Base of not found exception.
**/
class Sd3rd_NotFoundException extends Sd3rd_Exception
{
}

/**
 * Class not found exception.
**/
class Sd3rd_ClassNotFoundException extends Sd3rd_NotFoundException
{
}

/**
 * Process class not found exception.
**/
class Sd3rd_ProcessNotFoundException extends Sd3rd_ClassNotFoundException
{
    /**
     * Is fatal exception ?
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function isFatal()
    {
        return false;
    }
}
#endregion

#region invalid exception
/**
 * Base of invalid exception.
**/
class Sd3rd_InvalidException extends Sd3rd_Exception
{
}

/**
 * Invalid class exception.
**/
class Sd3rd_InvalidClassException extends Sd3rd_InvalidException
{
}
#endregion

#region error exception
/**
 * Base of error exception.
**/
class Sd3rd_ErrorException extends Sd3rd_Exception
{
}

/**
 * Paese error exception.
**/
class Sd3rd_ParseErrorException extends Sd3rd_ErrorException
{
}

/**
 * Query error exception.
**/
class Sd3rd_QueryErrorException extends Sd3rd_ErrorException
{
}
#endregion

?>
