<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD3RD_TRUST_PATH . '/class/AbstractMasterHandler.class.php';

/**
 * Sd3rd_SkillObject
**/
class Sd3rd_SkillObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('skill_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('skill_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('description', XOBJ_DTYPE_STRING, '', false, 255);
        $this->initVar('range', XOBJ_DTYPE_INT, '', false);
        $this->initVar('target_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('kind_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('tp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('register_time', XOBJ_DTYPE_INT, '', false);
    }
    
    /**
     * Get formated range value.
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function getRange()
    {
        static $map = array(-10 => '-',0 => _MD_SD3RD_LANG_WEAPON);
        $range = $this->get('range');
        return isset($map[$range]) ? $map[$range] : sprintf('%1.1f',$range * 0.1);
    }
}

/**
 * Sd3rd_SkillHandler
**/
class Sd3rd_SkillHandler extends Sd3rd_AbstractMasterHandler
{
    public /*** string ***/ $mTable = '{dirname}_skill';
    public /*** string ***/ $mPrimary = 'skill_id';
    public /*** string ***/ $mClass = 'Sd3rd_SkillObject';
    protected /*** string ***/ $_mIdColumn = 'skill_id';
    protected /*** string ***/ $_mValueColumn = 'skill_name';
    
    /**
     * Create new record at master data.
     * 
     * @param   mixed{} $values
     * @param   bool    $force
     * 
     * @return  void
    **/
    protected function _appendMaster(/*** mixed{} ***/ $values,/*** bool ***/ $force)
    {
        $element = $values['element'];
        unset($values['element']);
        $values['range'] *= 10;
        parent::_appendMaster($values,$force);
        $this->_setElement($this->getId($values[$this->_mValueColumn]),$element,$force);
    }
    
    /**
     * Set skill element list.
     * 
     * @param   int     $skillId
     * @param   int[]   $element
     * @param   bool    $force
     * 
     * @return  void
    **/
    protected function _setElement(/*** int ***/ $skillId,/*** int[] ***/ $element,/*** bool ***/ $force = false)
    {
        static $handler = null;
        if($handler === null)
        {
            $handler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::SKILL_ELEMENT);
        }
        $obj =& $handler->create();
        foreach($element as $elementId)
        {
            $obj->set('skill_id',$skillId);
            $obj->set('element_id',$elementId);
            $obj->setNew();
            if(!$handler->insert($obj,$force))
            {
                throw new Sd3rd_QueryErrorException('Cannot insert skill element data.');
            }
        }
    }
}

?>
