<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd3rd_SkillElementObject
**/
class Sd3rd_SkillElementObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('skill_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('element_id', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd3rd_SkillElementHandler
**/
class Sd3rd_SkillElementHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_skill_element';
    public /*** string ***/ $mPrimary = 'skill_id';
    public /*** string ***/ $mClass = 'Sd3rd_SkillElementObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
        parent::__construct($db);
    }
    
    /**
     * Get skill element id list.
     * 
     * @param   int $id
     * 
     * @return  int[]
    **/
    public function getList(/*** int ***/ $id)
    {
        $list = array();
        foreach($this->getObjects(new Criteria($this->mPrimary,$id)) as $obj)
        {
            $list[] = $obj->get('element_id');
        }
        return $list;
    }
}

?>
