<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd3rd_UpdateObject
**/
class Sd3rd_UpdateObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
    }
    
    /**
     * Get formated update time.
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function format()
    {
        return date('Y/m/d',strtotime(20000000 + $this->get('update_time')));
    }
}

/**
 * Sd3rd_UpdateHandler
**/
class Sd3rd_UpdateHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_update';
    public /*** string ***/ $mPrimary = 'update_time';
    public /*** string ***/ $mClass = 'Sd3rd_UpdateObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
        parent::__construct($db);
    }
    
    /**
     * Get update time list.
     * 
     * @param   void
     * 
     * @return  Sd3rd_UpdateObject[]
    **/
    public function getList()
    {
        $cri = new CriteriaCompo();
        $cri->addSort('update_time','DESC');
        return $this->getObjects($cri);
    }
}

?>
