<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Base of sub process.
**/
abstract class Sd3rd_AbstractProcess
{
    protected /*** int ***/ $_mUpdateTime = null;
    protected /*** ReflectionMethod ***/ $_mExecute = null;
    
    /**
     * Preparation process.
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        $this->_mUpdateTime = $updateTime;
        $this->_detectedExecute();
        if($this->_mExecute == null)
        {
            $this->_mExecute = new ReflectionMethod($this,'executeLatest');
        }
    }
    
    /** 
     * Detected execute process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _detectedExecute()
    {
        $class = new ReflectionClass($this);
        $methodList = array_filter($class->getMethods(),create_function('$m','return substr($m->name,0,7) == "execute";'));
        usort($methodList,create_function('$a,$b','return $a->name > $b->name;'));
        foreach($methodList as $method)
        {
            if(ctype_digit($date = substr($method->name,7)) && $date >= $this->_mUpdateTime)
            {
                $this->_mExecute = $method;
                break;
            }
        }
    }
    
    /**
     * Execute main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        $this->_mExecute->invoke($this);
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    abstract public function executeLatest();
}

/**
 * Base of filter process
**/
abstract class Sd3rd_AbstractFilter extends Sd3rd_AbstractProcess
{
    /**
     * Get priority of this process.
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_NORMAL;
    }
}

/**
 * Base of result parser.
**/
abstract class Sd3rd_AbstractParser extends Sd3rd_AbstractProcess
{
    protected /*** int ***/ $_mId = null;
    protected /*** string ***/ $_mSource = null;
    
    /**
     * Reset parser params.
     * 
     * @param   int $id
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id)
    {
        $this->_mId = $id;
    }
    
    /**
     * Set source text.
     * 
     * @param   string  $source
     * 
     * @return  void
    **/
    public function setSource(/*** string ***/ $source)
    {
        $this->_mSource = $source;
    }
}

/**
 * Base of file parser.
**/
abstract class Sd3rd_AbstractExecute extends Sd3rd_AbstractParser
{
    protected /*** string ***/ $_mParserPath = 'execute/parser';
    protected /*** string ***/ $_mPattern = '/^(?P<name>\w+)/';
    
    /**
     * Execute main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        parent::execute();
        $this->_dispose();
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $this->_parse();
    }
    
    /**
     * Parse result string.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _parse()
    {
        foreach(explode("\n",$this->_mSource) as $line)
        {
            try
            {
                $instance =& $this->_getParser(trim($line));
                $instance->execute();
                unset($instance);
            }
            catch(Sd3rd_ProcessNotFoundException $ex)
            {
            }
        }
    }
    
    /**
     * Get parser.
     * 
     * @param   string  $line
     * 
     * @return  Sd3rd_AbstractParser
    **/
    protected function _getParser(/*** string ***/ $line)
    {
        $arr = array();
        if(!preg_match($this->_mPattern,$line,$arr))
        {
            throw new Sd3rd_ProcessNotFoundException('No match at this pattern.');
        }
        $instance =& Sd3rd_UpdateUtils::getProcess($this->_mParserPath,$arr['name'],'Sd3rd_AbstractParser');
        $instance->reset($this->_mId);
        $instance->setSource($line);
        return $instance;
    }
    
    /**
     * Finalize process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    abstract protected function _dispose();
}

?>
