<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Updater global context.
**/
class Sd3rd_Context
{
    protected static /*** mixed{}{} ***/ $_mValues = array();
    
    /**
     * Reset all data.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public static function reset()
    {
        self::$_mValues = array();
    }
    
    /**
     * resetSection
     * 
     * @param   string  $section
     * 
     * @return  void
    **/
    public static function resetSection(/*** string ***/ $section)
    {
        if(!isset(self::$_mValues[$section]))
        {
            throw new Sd3rd_NotFoundException('Request section is not found.');
        }
        unset(self::$_mValues[$section]);
    }
    
    /**
     * Set value.
     * 
     * @param   string  $section
     * @param   string  $key
     * @param   mixed   $value
     * 
     * @return  void
    **/
    public static function set(/*** string ***/ $section,/*** string ***/ $key,/*** mixed ***/ $value)
    {
        self::$_mValues[$section][$key] = $value;
    }
    
    /**
     * Get request value.
     * 
     * @param   string  $section
     * @param   string  $key
     * 
     * @return  mixed
    **/
    public static function get(/*** string ***/ $section,/*** string ***/ $key)
    {
        if(!isset(self::$_mValues[$section][$key]))
        {
            throw new Sd3rd_NotFoundException('Request key is not found.');
        }
        return self::$_mValues[$section][$key];
    }
    
    /**
     * Get request section values.
     * 
     * @param   string  $section
     * 
     * @return  mixed{}
    **/
    public static function getSection(/*** string ***/ $section)
    {
        if(!isset(self::$_mValues[$section]))
        {
            throw new Sd3rd_NotFoundException('Request section is not found.');
        }
        return self::$_mValues[$section];
    }
}

?>
