<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

require_once SD3RD_TRUST_PATH . '/class/Sd3rdUtils.class.php';
require_once SD3RD_TRUST_PATH . '/class/AssetManager.class.php';
require_once SD3RD_TRUST_PATH . '/class/updater/Context.class.php';
require_once SD3RD_TRUST_PATH . '/class/updater/AbstractProcess.class.php';

/**
 * Utility of updater.
**/
class Sd3rd_UpdateUtils
{
    protected static /*** Sd3rd_AssetManager ***/ $_mAsset = null;
    protected static /*** string{} ***/ $_mEncoding = array();
    
    /**
     * Setup process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public static function setup()
    {
        $root =& XCube_Root::getSingleton();
        $dirname = $root->getSiteConfig('Sd3rd','publicName');
        $root->mLanguageManager->loadModuleMessageCatalog($dirname);
        self::$_mAsset =& Sd3rd_AssetManager::getInstance($dirname);
        self::$_mEncoding = $root->getSiteConfig('Sd3rd.Encoding');
    }
    
    #region output methods
    /**
     * Output message.
     * 
     * @param   string  $message
     * @param   bool    $lf
     * 
     * @return  void
    **/
    public static function output(/*** string ***/ $message = null,/*** bool ***/ $lf = true)
    {
        echo self::convertToOutput($message);
        $lf && self::output("\n",false);
    }
    
    /**
     * Output error message.
     * 
     * @param   Sd3rd_Exception $ex
     * @param   callback        $callback
     * 
     * @return  void
    **/
    public static function outputError(Sd3rd_Exception $ex,/*** callback ***/ $callback = null)
    {
        self::output($ex->__toString());
        if(is_callable($callback))
        {
            call_user_func($callback);
        }
        if($ex->isFatal())
        {
            die();
        }
    }
    #endregion
    
    #region process methods
    /**
     * Execute filter list.
     * 
     * @param   Enum    $mode
     * @param   string  $type
     * 
     * @return  void
    **/
    public static function executeFilter(/*** Enum ***/ $mode,/*** string ***/ $type = 'Sd3rd_AbstractFilter')
    {
        $process = new XCube_Delegate();
        foreach(self::getFileList($mode) as $file)
        {
            $filter = self::makeInstance($mode,$file,$type);
            $filter->prepare(SD3RD_UPDATE_TIME);
            $process->add(array($filter,'execute'),$filter->getPriority());
            unset($filter);
        }
        try
        {
            $process->call();
        }
        catch(Sd3rd_Exception $ex)
        {
            self::outputError($ex);
        }
    }
    
    /**
     * Get sub process.
     * 
     * @param   Enum    $mode
     * @param   string  $name
     * @param   string  $type
     * 
     * @return  Sd3rd_AbstractProcess
    **/
    public static function getProcess(/*** Enum ***/ $mode,/*** string ***/ $name,/*** string ***/ $type = 'Sd3rd_AbstractProcess')
    {
        static $cache = array();
        if(!isset($cache[$mode]))
        {
            $cache[$mode] = self::getProcessCache($mode,$type);
        }
        if(!isset($cache[$mode][$name = self::makeClassName($mode,$name)]))
        {
            throw new Sd3rd_ProcessNotFoundException('Request process is not found.');
        }
        return $cache[$mode][$name];
    }
    
    /**
     * Get sub process list.
     * 
     * @param   Enum    $mode
     * @param   string  $type
     * 
     * @return  Sd3rd_AbstractProcess{}
    **/
    public static function getProcessCache(/*** Enum ***/ $mode,/*** string ***/ $type)
    {
        $list = array();
        foreach(self::getFileList($mode) as $file)
        {
            $list[$name = self::makeClassNameFromPath($mode,$file)] = self::makeInstance($mode,$file,$type);
            $list[$name]->prepare(SD3RD_UPDATE_TIME);
        }
        return $list;
    }
    
    /**
     * Get sub process file list.
     * 
     * @param   Enum    $mode
     * 
     * @return  string[]
    **/
    public static function getFileList(/*** Enum ***/ $mode)
    {
        return glob(SD3RD_TRUST_PATH . '/class/updater/' . $mode . '/*.class.php');
    }
    
    /**
     * Get sub process instance.
     * 
     * @param   Enum    $mode
     * @param   string  $file
     * @param   string  $type
     * 
     * @return  $type
    **/
    public static function makeInstance(/*** Enum ***/ $mode,/*** string ***/ $file,/*** string ***/ $type = 'Sd3rd_AbstractProcess')
    {
        require_once $file;
        if(!class_exists($class = self::makeClassNameFromPath($mode,$file)))
        {
            throw new Sd3rd_ClassNotFoundException(sprintf('Class "%s" is not found.',$class));
        }
        $instance = new $class();
        if(!$instance instanceof $type)
        {
            throw new Sd3rd_InvalidClassException(sprintf('"%s" is not implements "%s".',$class,$type));
        }
        return $instance;
    }
    
    /**
     * Get sub process name.
     * 
     * @param   Enum    $mode
     * @param   string  $name
     * 
     * @return  string
    **/
    public static function makeClassName(/*** Enum ***/ $mode,/*** string ***/ $name)
    {
        return 'Sd3rd_' . ucfirst($name) . ucfirst(basename($mode));
    }
    
    /**
     * Get sub process name from file path.
     * 
     * @param   Enum    $mode
     * @param   string  $path
     * 
     * @return  string
    **/
    public static function makeClassNameFromPath(/*** Enum ***/ $mode,/*** string ***/ $path)
    {
        return self::makeClassName($mode,substr(basename($path),0,-10));
    }
    #endregion
    
    #region convert methods
    /**
     * Convert message from input encoding to internal encoding.
     * 
     * @param   string  $message
     * 
     * @return  string
    **/
    public static function convertFromInput(/*** string ***/ $message)
    {
        return Sd3rd_Utils::normalizeString(mb_convert_encoding($message,mb_internal_encoding(),self::$_mEncoding['input']));
    }
    
    /**
     * Convert message from internal encoding to output encoding.
     * 
     * @param   string  $message
     * 
     * @return  string
    **/
    public static function convertToOutput(/*** string ***/ $message)
    {
        return mb_convert_encoding($message,self::$_mEncoding['output'],mb_internal_encoding());
    }
    
    /**
     * Get table name from table type.
     * 
     * @param   Enum    $type
     * 
     * @return  string
    **/
    public static function convertTableName(/*** Enum ***/ $type)
    {
        return self::getHandler($type)->mTable;
    }
    #endregion
    
    #region parse methods
    /**
     * Parse line by regex.
     * 
     * @param   string  $line
     * @param   string  $pattern
     * 
     * @return  string{}
    **/
    public static function parseByRegex(/*** string ***/ $line,/*** string ***/ $pattern)
    {
        $arr = array();
        if(!preg_match($pattern,$line,$arr))
        {
            throw new Sd3rd_ParseErrorException('No match at pattern.',array('line' => $line,'pattern' => $pattern));
        }
        return $arr;
    }
    
    /**
     * Parse line by explode.
     * 
     * @param   string  $line
     * @param   int     $cnt
     * @param   int     $offset
     * @param   int     $end
     * @param   string  $splitter
     * 
     * @return  string[]
    **/
    public static function parseByExplode(/*** string ***/ $line,/*** int ***/ $cnt,/*** int ***/ $offset,/*** int ***/ $end = null,/*** string ***/ $splitter = ',')
    {
        $arr = $end != null ? explode($splitter,substr($line,$offset,$end)) : explode($splitter,substr($line,$offset));
        if(count($arr) != $cnt)
        {
            throw new Sd3rd_ParseErrorException('Mismatch token length.',array('line' => $line,'count' => $cnt,'offset' => $offset,'end' => $end,'splitter' => $splitter,'result' => $arr));
        }
        return $arr;
    }
    
    /**
     * Parse line by named explode.
     * 
     * @param   string      $line
     * @param   string[]    $nameList
     * @param   int         $offset
     * @param   int         $end
     * @param   string      $splitter
     * 
     * @return  string[]
    **/
    public static function parseByExplodeWithName(/*** string ***/ $line,/*** string[] ***/ $nameList,/*** int ***/ $offset,/*** int ***/ $end = null,/*** string ***/ $splitter = ',')
    {
        try
        {
            return array_combine($nameList,self::parseByExplode($line,count($nameList),$offset,$end,$splitter));
        }
        catch(Sd3rd_ParseErrorException $ex)
        {
            $ex->set('nameList',$nameList);
            throw $ex;
        }
    }
    #endregion
    
    #region handler methods
    /**
     * Get object handler.
     * 
     * @param   Enum    $name
     * 
     * @return  XoopsObjectGenericHandler
    **/
    public static function getHandler(/*** Enum ***/ $name)
    {
        return self::$_mAsset->getObject('handler',$name);
    }
    
    /**
     * Get object.
     * 
     * @param   Enum    $type
     * 
     * @return  XoopsSimpleObject
    **/
    public static function createObject(/*** Enum ***/ $type)
    {
        return self::getHandler($type)->create();
    }
    
    /**
     * Update object.
     * 
     * @param   Enum                $type
     * @param   XoopsSimpleObject   &$obj
     * 
     * @return  void
    **/
    public static function insertObject(/*** Enum ***/ $type,XoopsSimpleObject &$obj)
    {
        if(!self::getHandler($type)->insert($obj,true))
        {
            throw new Sd3rd_QueryErrorException('Cannot insert object.',array('type' => $type,'object' => $obj));
        }
    }
    
    /**
     * Delete object.
     * 
     * @param   Enum                $type
     * @param   XoopsSimpleObject   $obj
     * 
     * @return  void
    **/
    public static function deleteObject(/*** Enum ***/ $type,XoopsSimpleObject $obj)
    {
        if(!self::getHandler($type)->delete($obj,true))
        {
            throw new Sd3rd_QueryErrorException('Cannot delete object.',array('type' => $type,'object' => $obj));
        }
    }
    
    /**
     * Delete objects.
     * 
     * @param   Enum            $type
     * @param   CriteriaElement $cri
     * 
     * @return  void
    **/
    public static function deleteMultiObjects(/*** Enum ***/ $type,CriteriaElement $cri)
    {
        if(!$handler->deleteAll($cri,true))
        {
            throw new Sd3rd_QueryErrorException('Cannot delete objects.',array('type' => $type,'criteria' => $cri));
        }
    }
    
    /**
     * Cleanup related table.
     * 
     * @param   Enum    $base
     * @param   Enum    $target
     * 
     * @return  void
    **/
    public static function cleanupTable(/*** Enum ***/ $base,/*** Enum ***/ $target)
    {
        $sql = 'DELETE `t` FROM `%1$s` AS t LEFT JOIN `%2$s` AS b USING (`%3$s`) WHERE `b`.`%3$s` IS NULL';
        $handler = self::getHandler($base);
        if(!$handler->db->queryF(sprintf($sql,self::convertTableName($target),$handler->mTable,$handler->mPrimary)))
        {
            throw new Sd3rd_QueryErrorException('Cannot cleanup table.',array('base' => $base,'target' => $target));
        }
    }
    #endregion
}

?>
