<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

require_once SD3RD_TRUST_PATH . '/class/updater/UpdateUtils.class.php';

/**
 * Controller of analyze process.
**/
class Sd3rd_Updater
{
    protected /*** string ***/ $_mZipName = null;
    protected /*** string ***/ $_mPattern = null;
    protected /*** mixed{}{} ***/ $_mProgress = array();
    
    /**
     * Constructor of updater.
     * 
     * @param   string  $zipName
     * 
     * @return  void
    **/
    public function __construct(/*** string ***/ $zipName)
    {
        $this->_mZipName = $zipName;
        $root =& XCube_Root::getSingleton();
        $this->_mPattern = $root->getSiteConfig('Sd3rd','extractionPattern');
        $this->_mProgress = $root->getSiteConfig('Sd3rd.Progress');
        $this->_mProgress['message'] = $root->getSiteConfig('Sd3rd.Progress.message');
        Sd3rd_UpdateUtils::setup();
        $this->_outputMessage('start');
    }
    
    /**
     * Preparation process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function prepare()
    {
        $this->_outputMessage('prepare');
        Sd3rd_UpdateUtils::executeFilter('prepare');
    }
    
    /**
     * Main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        $this->_outputMessage('execute');
        $zip = new ZipArchive();
        $zip->open($this->_mZipName);
        for($i = 0;$i < $zip->numFiles;$i++)
        {
            try
            {
                $instance =& $this->_getProcess($zip->getNameIndex($i));
                $instance->setSource(Sd3rd_UpdateUtils::convertFromInput($zip->getFromIndex($i)));
                $instance->execute();
                unset($instance);
                $this->_outputProgress($i);
            }
            catch(Sd3rd_ProcessNotFoundException $ex)
            {
            }
            catch(Sd3rd_Exception $ex)
            {
                Sd3rd_UpdateUtils::outputError($ex,array($zip,'close'));
            }
        }
        Sd3rd_UpdateUtils::output();
        $zip->close();
    }
    
    /**
     * Finalize process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function dispose()
    {
        $this->_outputMessage('dispose');
        Sd3rd_UpdateUtils::executeFilter('dispose');
        $this->_outputMessage('finish');
    }
    
    /**
     * Output progress message.
     * 
     * @param   Enum    $key
     * 
     * @return  void
    **/
    protected function _outputMessage(/*** Enum ***/ $key)
    {
        if(!isset($this->_mProgress['message'][$key]))
        {
            throw new Sd3rd_InvalidException('Invalid message type.');
        }
        Sd3rd_UpdateUtils::output($this->_mProgress['message'][$key]);
    }
    
    /**
     * Get sub process controller.
     * 
     * @param   string  $name
     * 
     * @return  Sd3rd_AbstractProcess
    **/
    protected function &_getProcess(/*** string ***/ $name)
    {
        $arr = array();
        if(!preg_match($this->_mPattern,$name,$arr))
        {
            throw new Sd3rd_ProcessNotFoundException('No match at extraction pattern.');
        }
        $instance =& Sd3rd_UpdateUtils::getProcess('execute',$arr['name'],'Sd3rd_AbstractExecute');
        $instance->reset($arr['id']);
        return $instance;
    }
    
    /**
     * Output progress token.
     * 
     * @param   int $i
     * 
     * @return  void
    **/
    protected function _outputProgress(/*** int ***/ $i)
    {
        if($i % $this->_mProgress['spanNormal'] == 0)
        {
            Sd3rd_UpdateUtils::output($i % $this->_mProgress['spanSpecial'] == 0 ? $this->_mProgress['markSpecial'] : $this->_mProgress['markNormal'],false);
        }
    }
}

?>
