<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Data backup process.
**/
class Sd3rd_BackupDispose extends Sd3rd_AbstractFilter
{
    const MAX_ROWS = 500;
    const EXPORT_PATH = '%s/class/updater/backup/sd3rd_%06d.sql';
    const EXPORT_HEADER = "-- Backup of %s.\n\nSET NAMES %s;\n\n-- Refresh tables.\n%s\n\n-- Disable keys.\n%s\n\n-- Insert data.\n";
    const EXPORT_MAIN_FETCH = 'SELECT * FROM `%s`';
    const EXPORT_MAIN_BASE = "INSERT DELAYED INTO `%s` (`%s`) VALUES \n%%s;\n\n";
    const EXPORT_FOOTER = "\n-- Enable keys.\n%s\n\n-- Optimize tables.\nOPTIMIZE TABLE \n%s;\n";
    protected /*** string ***/ $_mFileName = null;
    protected /*** Enum[] ***/ $_mTableList = array();
    protected /*** resource ***/ $_mHandler = null;
    protected /*** XoopsDatabase ***/ $_mDB = null;
    
    /**
     * Get process priority.
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * Main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        parent::execute();
        $this->_mFileName = sprintf(self::EXPORT_PATH,SD3RD_TRUST_PATH,$this->_mUpdateTime);
        $this->_mTableList = array_map(array('Sd3rd_UpdateUtils','convertTableName'),$this->_mTableList);
        $this->_mDB =& XCube_Root::getSingleton()->mController->mDB;
        if(!is_resource($this->_mHandler = fopen($this->_mFileName,'wb')))
        {
            throw new Sd3rd_InvalidException(sprintf('Backup file is not writable.',$this->_mFileName));
        }
        try
        {
            $this->_exportHeader();
            $this->_exportMain();
            $this->_exportFooter();
        }
        catch(Sd3rd_Exception $ex)
        {
            fclose($this->_mHandler);
            throw $ex;
        }
        fclose($this->_mHandler);
    }
    
    /**
     * Append string to backup file.
     * 
     * @param   string  $message
     * 
     * @return  void
    **/
    protected function _append(/*** string ***/ $message)
    {
        fwrite($this->_mHandler,$message);
    }
    
    /**
     * Append export header.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _exportHeader()
    {
        $truncate = array();
        $disable = array();
        foreach($this->_mTableList as $table)
        {
            $truncate[] = sprintf('TRUNCATE TABLE `%s`;',$table);
            $disable[] = sprintf('ALTER TABLE `%s` DISABLE KEYS;',$table);
        }
        $this->_append(sprintf(self::EXPORT_HEADER,basename($this->_mFileName),XCube_Root::getSingleton()->getSiteConfig('Sd3rd.Encoding','database'),implode("\n",$truncate),implode("\n",$disable)));
    }
    
    /**
     * Append export body.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _exportMain()
    {
        foreach($this->_mTableList as $table)
        {
            $this->_exportTable($table);
        }
    }
    
    /**
     * Append export body by table.
     * 
     * @param   string  $table
     * 
     * @return  void
    **/
    protected function _exportTable(/*** string ***/ $table)
    {
        if(!$res = $this->_mDB->query(sprintf(self::EXPORT_MAIN_FETCH,$table)))
        {
            throw new Sd3rd_QueryErrorException(sprintf('Cannot readable table at "%s".',$table));
        }
        $base = $this->_makeExportBase($table,$res);
        $rows = array();
        $cnt = 0;
        while($row = $this->_mDB->fetchArray($res))
        {
            $rows[] = '(' . implode(',',array_map(array($this->_mDB,'quoteString'),$row)) . ')';
            if($cnt++ >= self::MAX_ROWS)
            {
                $this->_appendRows($base,$rows);
                $rows = array();
                $cnt = 0;
            }
        }
        if($cnt > 0)
        {
            $this->_appendRows($base,$rows);
        }
    }
    
    /**
     * Create base of export body.
     * 
     * @param   string      $table
     * @param   resource    $res
     * 
     * @return  string
    **/
    protected function _makeExportBase(/*** string ***/ $table,/*** string ***/ $res)
    {
        $cols = array();
        $len = $this->_mDB->getFieldsNum($res);
        for($i = 0;$i < $len;$i++)
        {
            $cols[] = $this->_mDB->getFieldName($res,$i);
        }
        return sprintf(self::EXPORT_MAIN_BASE,$table,implode('`,`',$cols));
    }
    
    /**
     * Append export body by rows.
     * 
     * @param   string      $base
     * @param   string[]    $rows
     * 
     * @return  void
    **/
    protected function _appendRows(/*** string ***/ $base,/*** string[] ***/ $rows)
    {
        $this->_append(sprintf($base,implode(",\n",$rows)));
    }
    
    /**
     * Append export footer.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _exportFooter()
    {
        $enable = array();
        $optimize = array();
        foreach($this->_mTableList as $table)
        {
            $enable[] = sprintf('ALTER TABLE `%s` ENABLE KEYS;',$table);
            $optimize[] = sprintf('`%s`',$table);
        }
        $this->_append(sprintf(self::EXPORT_FOOTER,implode("\n",$enable),implode(",\n",$optimize)));
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $this->_mTableList = array(
            Sd3rd_HANDLER::ABILITY,
            Sd3rd_HANDLER::CHAR,
            Sd3rd_HANDLER::COSTUME,
            Sd3rd_HANDLER::KIND,
            Sd3rd_HANDLER::SKILL,
            Sd3rd_HANDLER::SKILL_ELEMENT,
            Sd3rd_HANDLER::TARGET,
            Sd3rd_HANDLER::UPDATE
        );
    }
}

?>
