<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Extract process for Chardata at weapon skill
**/
class Sd3rd_WSkill_DataChar extends Sd3rd_AbstractParser
{
    protected /*** Sd3rd_SkillHandler ***/ $_mHandler = null;
    protected /*** Sd3rd_TargetHandler ***/ $_mTargetHandler = null;
    protected /*** Sd3rd_SkillElementHandler ***/ $_mElementHandler = null;
    protected /*** Sd3rd_KindHandler ***/ $_mKindHandler = null;
    
    /**
     * Constructor of this process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->_mHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::SKILL);
        $this->_mTargetHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::TARGET);
        $this->_mElementHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::SKILL_ELEMENT);
        $this->_mKindHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::KIND);
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)','(?P<desc>[^']*)','?(?P<range>[-\d\.]+)'?,'(?P<target>[^']+)','[\d,]+','?(?P<element>[-\d,]+)'?,'(?P<kind>[^']+)',(?P<tp>\d+),(?P<cnt>\d+),(?P<is_new>\d)\)/");
        $targetId = $this->_mTargetHandler->getId($data['target'],array(),true);
        $kindId = $this->_mKindHandler->getId($data['kind'],array(),true);
        $id = $this->_mHandler->getId($data['name'],array('description' => $data['desc'],'range' => $data['range'],'target_id' => $targetId,'element' => explode(',',$data['element']),'kind_id' => $kindId,'tp' => $data['tp'],'register_time' => $this->_mUpdateTime),true);
    }
    
    /**
     * Main process for before 20090923.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute090923()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)','(?P<desc>[^']*)','?(?P<range>[-\d\.]+)'?,'(?P<target>[^']+)','[\d,]+','?(?P<element>[-\d,]+)'?,'(?P<kind>[^']+)',(?P<tp>\d+),(?P<cnt>\d+)\)/");
        $targetId = $this->_mTargetHandler->getId($data['target'],array(),true);
        $kindId = $this->_mKindHandler->getId($data['kind'],array(),true);
        $id = $this->_mHandler->getId($data['name'],array('description' => $data['desc'],'range' => $data['range'],'target_id' => $targetId,'element' => explode(',',$data['element']),'kind_id' => $kindId,'tp' => $data['tp'],'register_time' => $this->_mUpdateTime),true);
    }
}

?>
