<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Setup context at master data.
**/
class Sd3rd_SetupContextPrepare extends Sd3rd_AbstractFilter
{
    /**
     * Get process priority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        foreach(array(Sd3rd_HANDLER::ABILITY,Sd3rd_HANDLER::COSTUME,Sd3rd_HANDLER::KIND,Sd3rd_HANDLER::SKILL,Sd3rd_HANDLER::TARGET) as $table)
        {
            Sd3rd_UpdateUtils::getHandler($table)->setupMaster();
        }
    }
}

?>
