<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD3RD_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('SD3RD_COSTUME_SORT_KEY_COSTUME_NAME', 1);
define('SD3RD_COSTUME_SORT_KEY_DEFAULT', SD3RD_COSTUME_SORT_KEY_COSTUME_NAME);

/**
 * Sd3rd_CostumeFilterForm
**/
class Sd3rd_CostumeFilterForm extends Sd3rd_AbstractFilterForm
{
    public /*** string[] ***/ $mSortKeys = array(
        SD3RD_COSTUME_SORT_KEY_COSTUME_NAME => 'costume_name',
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return SD3RD_COSTUME_SORT_KEY_DEFAULT;
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
    
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
    
        if(($value = $request->getRequest('register_time')) !== null)
        {
            if(ctype_digit($value))
            {
                $value = intval($value);
                $this->_mCriteria->add(new Criteria('register_time', $value));
            }
            else
            {
                $value = null;
            }
        }
        $this->mNavi->addExtra('register_time', $value);
    
        $this->_mCriteria->addSort($this->getSort(), $this->getOrder());
    }
}

?>
