﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using Twitter;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.IO;

namespace Musitters
{
    [DataContract]
    class TwitterUser
    {

        private Auth auth;

        public TwitterUser(string consumerKey, string consumerSecret,
                string accessToken, string accessTokenSecret,
                string userId, string screenName)
        {
            this.auth = new Auth(consumerKey, consumerSecret,
                accessToken, accessTokenSecret,
                userId, screenName);
            Dictionary<string, string> parameters = new Dictionary<string, string>();
            parameters.Add("q", auth.UrlEncode(screenName));
            String s = auth.Get("https://api.twitter.com/1.1/users/search.json", parameters);
            s = s.TrimStart('[');
            s = s.TrimEnd(']');

            //（2）DataContractJsonSerializerをインスタンス化
            var serializer = new DataContractJsonSerializer(typeof(TwitterUser));

            //（3）JSONデータを文字列からバイト配列に変換
            var jsonBytes = Encoding.Unicode.GetBytes(s);

            //（4）バイト配列を読み込むMemoryStreamクラスを定義
            var sr = new MemoryStream(jsonBytes);

            //（5）ReadObjectメソッドでJSONデータを.NETオブジェクトに変換
            var obj = (TwitterUser)serializer.ReadObject(sr);
            this.name = obj.name;
            this.ScreenName = screenName;
        }

        [DataMember]
        public string name { get; set; }

        [DataMember]
        public string ScreenName { get; set; }

    }
}
