#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEFramePeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEFramePeer
 * Method:    createNativeFrame
 * Signature: (IIIIZ)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEFramePeer_createNativeFrame(JNIEnv *env, jobject peer_obj, jint hwndParent, jint x, jint y, jint width, jint height, jboolean undecorated) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	return (jint) create_native_frame(peer_obj, (HWND) hwndParent, x, y, width, height, undecorated);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEFramePeer
 * Method:    getMenuBarWindowHandle
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEFramePeer_getMenuBarWindowHandle(JNIEnv *env, jobject peer_obj, jint frameWindowHandle) {
	return (jint) get_menu_bar_of((HWND) frameWindowHandle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEFramePeer
 * Method:    setNativeResizable
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEFramePeer_setNativeResizable(JNIEnv *env, jobject peer_obj, jint frameWindowHandle, jboolean resizable) {
	LONG lStyle = GetWindowLong((HWND) frameWindowHandle, GWL_STYLE);
	if (resizable) {
		lStyle |= WS_THICKFRAME;
	} else {
		lStyle &= ~WS_THICKFRAME;
	}
	SetWindowLong((HWND) frameWindowHandle, GWL_STYLE, lStyle);
	SetWindowPos((HWND) frameWindowHandle,
                  0,
				  0, 0, 0, 0,
				  SWP_NOSIZE |  SWP_NOMOVE | SWP_NOZORDER | SWP_DRAWFRAME);

}
