/* WCEGraphicsDevice.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;

/**
 * OtBbNfoCX
 */
public class WCEGraphicsDevice extends GraphicsDevice {

	public WCEGraphicsDevice() {
	}
	
	public int getType() {
		return TYPE_RASTER_SCREEN;
	}
	
	public String getIDstring() {
		return "Screen";
	}
	
	public GraphicsConfiguration[] getConfigurations() {
		GraphicsConfiguration[] configs = new GraphicsConfiguration[1];
		configs[0] = new WCEGraphicsConfiguration(this);
		return configs;
	}
	
	public GraphicsConfiguration getDefaultConfiguration() {
		return new WCEGraphicsConfiguration(this);
	}
	
	public DisplayMode getDisplayMode() {
		Rectangle bounds = getConfigurations()[0].getBounds();
		return new DisplayMode(bounds.width,
							   bounds.height,
							   DisplayMode.BIT_DEPTH_MULTI,
							   DisplayMode.REFRESH_RATE_UNKNOWN);
	}
	
	public synchronized void setFullScreenWindow(Window w) {
		WCEWindowPeer peer = null;
		boolean fullscreen = false;
		if (w == null) {
			if (getFullScreenWindow() != null) {
				// tXN[[hEChE[hɖ߂
				peer = (WCEWindowPeer) getFullScreenWindow().getPeer();
				fullscreen = false;
			}
		} else {
			// EChE[htXN[[hɈڍs
			if (w.getPeer() == null) {
				w.addNotify();
			}
			peer = (WCEWindowPeer) w.getPeer();
			fullscreen = true;
		}
		
		if (peer != null) {
			setNativeFullScreen(peer.getWindowHandle(), fullscreen);
		}
		
		super.setFullScreenWindow(w);
	}
	
	/**
	 * Windows CESHFullScreen()Ăяo
	 */
	private native void setNativeFullScreen(int windowHandle, boolean fullscreen);
}
