/* WCEMenuBarPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.peer.MenuBarPeer;

public class WCEMenuBarPeer extends WCEMenuComponentPeer implements MenuBarPeer {
	
	/**
	 * j[o[̃EChEnh
	 */
	private int menuBarWindowHandle;
	
	WCEMenuBarPeer(MenuBar menuBar) {
		super(menuBar);
	}
	
	/**
	 * j[o[̃EChEnhݒ肷B
	 * WCEFramePeer.setMenuBar()Ăяo
	 */
	void setMenuBarWindowHandle(int handle) {
		this.menuBarWindowHandle = handle;
	}
	
	/**
	 * j[o[̃EChEnhԂ
	 */
	int getMenuBarWindowHandle() {
		return this.menuBarWindowHandle;
	}
	
	/**
	 * w肳ꂽMenuPeerj[o[ɒǉ
	 */
	void add(WCEMenuPeer menuPeer) {
		menuPeer.setMenuBarPeer(this);
		
		Menu menu = (Menu) menuPeer.getMenuComponent();
		addNativeMenu(getMenuBarWindowHandle(),
					  menuPeer.getMenuHandle(),
					  menu.getLabel());
	}
	
	/**
	 * w肳ꂽj[j[o[ɒǉ
	 *
	 * @param	menuBarWindowHandle	j[o[̃EChEnh
	 * @paam	menuHandle			ǉ郁j[̃j[nh
	 * @param	label				x
	 */
	native void addNativeMenu(int menuBarWindowHandle, int menuHandle, String label);
	
	
	public void addHelpMenu(Menu menu) {
		// ToDo:wvj[ǉ
	}
	
	/**
	 * w肳ꂽCfbNXʒuɂ郁j[
	 * j[o[폜
	 */
	public void delMenu(int index) {
		deleteNativeMenuByPosition(getMenuBarWindowHandle(), index);
	}
	
	/**
	 * ̃j[o[Ɋ֘Atꂽj[o[̓e
	 * SăNA
	 */
	public void dispose() {
		disposeNativeMenuBar(getMenuBarWindowHandle());
	}
	
	private native void disposeNativeMenuBar(int menuBarWindowHandle);

	/**
	 * j[j[o[菜
	 */
	native void deleteNativeMenuByHandle(int menuBarWindowHandle, int menuHandle);

	/**
	 * j[j[o[菜
	 */
	private native void deleteNativeMenuByPosition(int menuBarWindowHandle, int index);


	public void addMenu(Menu m) {
		if (getMenuBarWindowHandle() != 0) {
			// łMenuBar\Ԃ̏ꍇ́Aǉ
			add((WCEMenuPeer) m.getPeer());
		} else {
			// iWCEFramePeer.setMenuBar()Œǉs邽߁A
			//  @\Ԃ̏ꍇɂ͉Ȃj
		}
	}

}
