/* WCEWindowPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import gnu.java.awt.peer.wce.event.WCEWindowBoundsEvent;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;

public class WCEWindowPeer extends WCEContainerPeer implements WindowPeer {
	private int x;
	private int y;
	private int width;
	private int height;
	
	/**
	 * WindowEvent.WINDOW_OPENEDCxg𑗐Mς݂
	 */
	private boolean hasBeenOpened;

	/**
	 * ̃tOtrue̊Ԃ́AsetBounds()ւ̌Ăяo𖳎
	 * @since	GNU Classpath 0.18
	 */
	private boolean ignoreResize = false;

	public WCEWindowPeer(Window w) {
		super(w);

		// lLbVĂ
		this.x = w.getX();
		this.y = w.getY();
		this.width = w.getWidth();
		this.height = w.getHeight();
	}
	
	protected native int createNative(int hParentWnd, int x, int y, int width, int height);
	
	/**
	 * ŔwʂɈړ
	 */
	public void toBack() {
		toNativeBack(getWindowHandle());
	}
	
	private native void toNativeBack(int windowHandle);

	/**
	 * őOʂɈړ
	 */
	public void toFront() {
		toNativeFront(getWindowHandle());
	}

	private native void toNativeFront(int windowHandle);
	
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible && ! this.hasBeenOpened) {
			// WINDOW_OPENED CxǵAŏ̂P񂾂
			postWindowEvent(WindowEvent.WINDOW_OPENED, null);
			this.hasBeenOpened = true;
			
			// GNU Classpath 0.90ŏύXꂽ̂ŁA
			// őOʂɎĂ
			toFront();
		}
	}
		
	/**
	 * EChECxg𑗐M
	 */
	void postWindowEvent(int id, WCEComponentPeer oppositePeer) {
		Window window = (Window) getComponent();
		Window opposite;
		if (oppositePeer instanceof WCEWindowPeer) {
			opposite = (Window) oppositePeer.getComponent();
		} else {
			opposite = null;
		}
		queue.postEvent(new WindowEvent(window, id, opposite));
	}
	
	
	/**
	 * WCEWindowBoundsEventpost
	 */
	void postWCEWindowBoundsEvent(int x, int y, int width, int height) {
//		System.err.println("WCEWindowPeer.postWCEWindowBoundsEvent():x=" + x + " y=" + y + " width=" + width + " height=" + height);
		queue.postEvent(new WCEWindowBoundsEvent((Window) getComponent(), x, y, width, height));
	}

	public void handleEvent(AWTEvent e) {
		if (e instanceof WCEWindowBoundsEvent) {
			WCEWindowBoundsEvent boundsEvent = (WCEWindowBoundsEvent) e;
			Window window = (Window) boundsEvent.getSource();

			// lLbVĂ
			this.x = boundsEvent.getX();
			this.y = boundsEvent.getY();
			this.width = boundsEvent.getWidth();
			this.height = boundsEvent.getHeight();

			if (window.isShowing()) {
				// Window.setBounds()ĂяoɂWCEWindowPeer.setBounds()ĂяoA
				// WCEWindowBoundsEventpostEEEƂ[vh
				// ŁuvtO𗧂ĂĂ
				this.ignoreResize = true;

				// R|[lgTCY
				window.setBounds(this.x,
								 this.y,
								 this.width,
								 this.height);
				
				// uvtONA
				this.ignoreResize = false;

				// ăCAEg
				if (! window.isValid()) {
					window.validate();
				}
			}
			
		} else {
			super.handleEvent(e);
		}
	}
	
	public void setBounds(int x, int y, int width, int height) {
		// lLbVĂ
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;

		if (this.ignoreResize) {
			// WCEWindowBoundsEventɋNWindow.setBounds()̌Ăяoł邽
			// Ƀ^[
			return;
		}
		super.setBounds(x, y, width, height);	// ̌ʁAWCEWindowBoundsEventpost
	}
	
	public Rectangle getBounds() {
		Rectangle r = new Rectangle(this.x, this.y, this.width, this.height);
//		System.err.println("WCEWindowPeer.getBounds():bounds=" + r);
		return r;
	}
	
  public void updateIconImages()
  {
    // TODO: Implement properly.
  }

  public void updateMinimumSize()
  {
    // TODO: Implement properly.
  }

  public void setModalBlocked(java.awt.Dialog d, boolean b)
  {
    // TODO: Implement properly.
  }

  public void updateFocusableWindowState()
  {
    // TODO: Implement properly.
  }

  public void updateAlwaysOnTop()
  {
    // TODO Auto-generated method stub
    
  }

  public void setAlwaysOnTop(boolean b)
  {
    // TODO: Implement properly.
  }

  public boolean requestWindowFocus()
  {
    // TODO Auto-generated method stub
    return false;
  }

}
