/* WCEFontPeer.java
   Copyright (C) 2005, 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce.font;

import gnu.java.awt.peer.ClasspathFontPeer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import java.util.Locale;
import java.util.Map;

public class WCEFontPeer extends ClasspathFontPeer {
	/**
	 * lCeButHgnh
	 */
	private int fontHandle;
	
	public WCEFontPeer(String name, int style, int size) {
		super(name, style, size);
	}
	
	public WCEFontPeer(String name, Map attrs) {
		super(name, attrs);
	}
	
	/**
	 * lCeButHgnhԂ
	 */
	public int getFontHandle() {
		if (this.fontHandle == 0) {
			this.fontHandle = createNativeFont(this.logicalName,
											   this.style,
											   (int) this.size);
		}
		return this.fontHandle;
	}
	
	private native int createNativeFont(String name, int style, int size);
	
	/**
	 * lCeButHg\[XJB
	 */
	public void dispose() {
		if (this.fontHandle != 0) {
			disposeNative(this.fontHandle);
			this.fontHandle = 0;
		}
	}
	
	/**
	 * lCeButHg\[XJB
	 */
	private native void disposeNative(int fontHandle);
	
	protected void finalize() {
		dispose();
	}
	
  public boolean canDisplay (Font font, int c)
  {
    // FIXME: inquire with pango
    return true;
  }

	public int canDisplayUpTo (Font font, CharacterIterator i, int start, int limit) {
		throw new UnsupportedOperationException();
	}
	
	public String getSubFamilyName (Font font, Locale locale) {
		throw new UnsupportedOperationException();
	}
	
	public String getPostScriptName (Font font) {
		throw new UnsupportedOperationException();
	}
	
	public int getNumGlyphs(Font font) {
		throw new UnsupportedOperationException();
	}
	
	public int getMissingGlyphCode (Font font) {
		throw new UnsupportedOperationException();
	}

	public byte getBaselineFor (Font font, char c) {
		throw new UnsupportedOperationException();
	}

	public String getGlyphName (Font font, int glyphIndex) {
		throw new UnsupportedOperationException();
	}

	public GlyphVector createGlyphVector (Font font,
                                                 FontRenderContext frc,
                                                 CharacterIterator ci) {
		throw new UnsupportedOperationException();
	}

	public GlyphVector createGlyphVector (Font font, 
                                          FontRenderContext ctx, 
                                          int[] glyphCodes) {
		throw new UnsupportedOperationException();
	}

	public GlyphVector layoutGlyphVector (Font font, 
                                                 FontRenderContext frc, 
                                                 char[] chars, int start, 
                                                 int limit, int flags) {
		return new WCEGlyphVector(font,
								  new String(chars, start, limit - start),
								  frc,
								  flags);

		
	}

	public FontMetrics getFontMetrics (Font font) {
		return new WCEFontMetrics(font);
	}

	public boolean hasUniformLineMetrics (Font font) {
		throw new UnsupportedOperationException();
	}

	public LineMetrics getLineMetrics (Font font, 
                                       CharacterIterator ci, 
                                       int begin, int limit, 
                                       FontRenderContext rc) {
		return new WCEFontLineMetrics(getFontMetrics(font), limit - begin);
	}

	
	public Rectangle2D getMaxCharBounds (Font font, 
                                                FontRenderContext rc) {
		throw new UnsupportedOperationException();
	}

	public Rectangle2D getStringBounds (Font font, 
                                        CharacterIterator ci, 
                                        int begin,
                                        int limit, 
                                        FontRenderContext frc) {
		char[] target = toCharArray(ci, begin, limit);
		Rectangle2D.Double r
			= getNativeStringBounds(getFontHandle(),
								    target);
		// ToDo: FontRenderContext gpčWϊs
		return r;
	}
	
	
	/**
	 * CharacterIteratorStringIuWFNg𐶐B
	 */
	private char[] toCharArray(CharacterIterator iter, int begin, int limit) {
		char[] result = new char[limit - begin];
		iter.setIndex(begin);
		for (int index = 0; index < result.length; index++) {
			result[index] = iter.current();
			iter.next();
		}
		return result;
	}

	/**
	 * w肳ꂽtHgnhgpāAchar[] z̕߂
	 * ʏ̑傫ԂB
	 *
	 * @param	fontHandle	tHgnh
	 * @param	target		ؑΏۂƂȂ镶̔z
	 */
	protected native Rectangle2D.Double getNativeStringBounds(int fontHandle,
															char[] target);
	

	/**
	 * LineMetrics
	 * (Copy from Gtk peer)
	 */
	protected class WCEFontLineMetrics extends LineMetrics {
		FontMetrics fm;
		int nchars; 

		public WCEFontLineMetrics (FontMetrics m, int n) {
			fm = m;
			nchars = n;
		}

		public float getAscent() {
			return (float) fm.getAscent ();
		}
  
		public int getBaselineIndex() {
			return Font.ROMAN_BASELINE;
		}
    
		public float[] getBaselineOffsets() {
			return new float[3];
		}
    
		public float getDescent() {
			return (float) fm.getDescent ();
		}
    
		public float getHeight() {
			return (float) fm.getHeight ();
		}
    
		public float getLeading() { return 0.f; }    
		public int getNumChars() { return nchars; }
		public float getStrikethroughOffset() { return 0.f; }    
		public float getStrikethroughThickness() { return 0.f; }  
		public float getUnderlineOffset() { return 0.f; }
		public float getUnderlineThickness() { return 0.f; }
	}

}
