package gnu.javax.sound.sampled.wce;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class WCEMixer extends WCELine implements Mixer {
	/**
	 * CxgL[
	 */
	private final static WCEEventQueue eventQueue;
	
	static {
		eventQueue = new WCEEventQueue();
		// CxgL[XbhJn
		Thread t = new Thread(eventQueue);
		t.start();
		
		// R[obNXbhJn
		WCECallbackWindowThread callbackWindowThread
			= new WCECallbackWindowThread(eventQueue);
		callbackWindowThread.start();

		// R[obNEChE܂ő҂
		try {
			callbackWindowThread.waitForInitialized();
		} catch (InterruptedException ie) {
			ie.printStackTrace();
		}
	}
	
	// foCXT|[gĂtH[}bg
	// \萔
	private static int WAVE_FORMAT_1M08   = 0x00000001;       /* 11.025 kHz, Mono,   8-bit  */
	private static int WAVE_FORMAT_1S08   = 0x00000002;       /* 11.025 kHz, Stereo, 8-bit  */
	private static int WAVE_FORMAT_1M16   = 0x00000004;       /* 11.025 kHz, Mono,   16-bit */
	private static int WAVE_FORMAT_1S16   = 0x00000008;       /* 11.025 kHz, Stereo, 16-bit */
	private static int WAVE_FORMAT_2M08   = 0x00000010;       /* 22.05  kHz, Mono,   8-bit  */
	private static int WAVE_FORMAT_2S08   = 0x00000020;       /* 22.05  kHz, Stereo, 8-bit  */
	private static int WAVE_FORMAT_2M16   = 0x00000040;       /* 22.05  kHz, Mono,   16-bit */
	private static int WAVE_FORMAT_2S16   = 0x00000080;       /* 22.05  kHz, Stereo, 16-bit */
	private static int WAVE_FORMAT_4M08   = 0x00000100;       /* 44.1   kHz, Mono,   8-bit  */
	private static int WAVE_FORMAT_4S08   = 0x00000200;       /* 44.1   kHz, Stereo, 8-bit  */
	private static int WAVE_FORMAT_4M16   = 0x00000400;       /* 44.1   kHz, Mono,   16-bit */
	private static int WAVE_FORMAT_4S16   = 0x00000800;       /* 44.1   kHz, Stereo, 16-bit */

	/**
	 * Mixer.Info
	 */
	private final Mixer.Info mixerInfo;
	
	/**
	 * I[vSourceDataLine
	 */
	private final List sourceLineList = new ArrayList();
	
	/**
	 * I[vTargetDataLine
	 */
	private final List targetLineList = new ArrayList();
	
	/**
	 * Windows CEpMixer̃CX^X쐬B
	 */
	public WCEMixer(Mixer.Info info) {
		super(new Line.Info(Mixer.class));
		this.mixerInfo = info;
	}
	
	public Mixer.Info getMixerInfo() {
		return this.mixerInfo;
	}
	
	
	/**
	 * lCeButH[}bgAAudioFormatɕϊ
	 *
	 * @see #getNativeSourceLineFormats()
	 * @see #getNativeTargetLineFormats()
	 */
	private AudioFormat[] toAudioFormatArray(int nativeFormats) {
		List list = new ArrayList();
		if ((nativeFormats & WAVE_FORMAT_1M08) != 0) {
			// 11.025 kHz, mono, 8-bit 
			list.add(new AudioFormat(11025.0f,
									 8,
									 1,		// mono
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_1M16) != 0) {
			// 11.025 kHz, mono, 16-bit 
			list.add(new AudioFormat(11025.0f,
									 16,
									 1,		// mono
									 true,	// signed
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_1S08) != 0) {
			// 11.025 kHz, stereo, 8-bit 
			list.add(new AudioFormat(11025.0f,
									 8,
									 2,		// stereo
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_1S16) != 0) {
			// 11.025 kHz, stereo, 16-bit 
			list.add(new AudioFormat(11025.0f,
									 16,
									 2,		// stereo
									 true,	// signed
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_2M08) != 0) {
			// 22.05 kHz, mono, 8-bit 
			list.add(new AudioFormat(22050.0f,
									 8,
									 1,		// mono
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_2M16) != 0) {
			// 22.05 kHz, mono, 16-bit 
			list.add(new AudioFormat(22050.0f,
									 16,
									 1,		// mono
									 true,	// signed
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_2S08) != 0) {
			// 22.05 kHz, stereo, 8-bit
			list.add(new AudioFormat(22050.0f,
									 8,
									 2,		// stereo
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_2S16) != 0) {
			// 22.05 kHz, stereo, 16-bit
			list.add(new AudioFormat(22050.0f,
									 16,
									 2,		// stereo
									 true,	// signed
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_4M08) != 0) {
			// 44.1 kHz, mono, 8-bit 
			list.add(new AudioFormat(44100.0f,
									 8,
									 1,		// mono
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_4M16) != 0) {
			// 44.1 kHz, mono, 16-bit 
			list.add(new AudioFormat(44100.0f,
									 16,
									 1,		// mono
									 true,	// signed
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_4S08) != 0) {
			// 44.1 kHz, stereo, 8-bit 
			list.add(new AudioFormat(44100.0f,
									 8,
									 2,		// stereo
									 false,	// unsigned
									 false));
		}
		if ((nativeFormats & WAVE_FORMAT_4S16) != 0) {
			// 44.1 kHz, stereo, 16-bit 
			list.add(new AudioFormat(44100.0f,
									 16,
									 2,		// stereo
									 true,	// signed
									 false));
		}
		
		return (AudioFormat[]) list.toArray(new AudioFormat[0]);
	}
	
	/**
	 * Windows CEo̓foCXT|[gtH[}bg
	 * `lԂB
	 * ߂ĺAWAVEOUTCAPS.dwFormats ̒lł
	 */
	private native int getNativeSourceLineFormats();
	
	public Line.Info[] getSourceLineInfo() {
		int nativeFormats = getNativeSourceLineFormats();
		AudioFormat[] formats = toAudioFormatArray(nativeFormats);
		return new Line.Info[] {
			new DataLine.Info(SourceDataLine.class,
							 formats,
							 AudioSystem.NOT_SPECIFIED,
							 AudioSystem.NOT_SPECIFIED) };
	}
	
	/**
	 * Windows CE̓foCXT|[g
	 * tH[}bg̈ꗗԂB
	 */
	private native int getNativeTargetLineFormats();
	
	public Line.Info[] getTargetLineInfo() {
		int nativeFormats = getNativeTargetLineFormats();
		AudioFormat[] formats = toAudioFormatArray(nativeFormats);
		return new Line.Info[] {
			new DataLine.Info(TargetDataLine.class,
							 formats,
							 AudioSystem.NOT_SPECIFIED,
							 AudioSystem.NOT_SPECIFIED) };
	}
	
	public Line.Info[] getSourceLineInfo(Line.Info info) {
		List list = new ArrayList();
		Line.Info[] allInfo = getSourceLineInfo();
		for (int i = 0; i < allInfo.length; ++i) {
			if (allInfo[i].matches(info)) {
				list.add(allInfo[i]);
			}
		}
		return (Line.Info[]) list.toArray(new Line.Info[0]);
	}
	
	public Line.Info[] getTargetLineInfo(Line.Info info) {
		List list = new ArrayList();
		Line.Info[] allInfo = getTargetLineInfo();
		for (int i = 0; i < allInfo.length; ++i) {
			if (allInfo[i].matches(info)) {
				list.add(allInfo[i]);
			}
		}
		return (Line.Info[]) list.toArray(new Line.Info[0]);
	}
	
	/**
	 * w肳ꂽLine.InfoɓKLineT|[gĂ邩
	 * ԂB
	 */
	public boolean isLineSupported(Line.Info info) {
		// ToDo: lCeBuCuŔf悤ɏC
		boolean result = true;
		try {
			getLine(info);
		} catch (Exception e) {
			result = false;
		}
		return result;
	}
	
	/**
	 * w肳ꂽLine.InfoɓKLineԂB
	 */
	public Line getLine(Line.Info info)
             throws LineUnavailableException {
		SecurityManager sm = System.getSecurityManager();
		
		Line result = null;
		if (info instanceof DataLine.Info) {
			DataLine.Info dinfo = (DataLine.Info) info;
			if (SourceDataLine.class.equals(dinfo.getLineClass())) {
				if (sm != null) {
					// ZLeB`FbN
					sm.checkPermission(new AudioPermission("play"));
				}
				result = new WCESourceDataLine(dinfo);
			} else if (TargetDataLine.class.equals(dinfo.getLineClass())) {
				if (sm != null) {
					// ZLeB`FbN
					sm.checkPermission(new AudioPermission("record"));
				}
				result = new WCETargetDataLine(dinfo);
			} else if (Clip.class.equals(dinfo.getLineClass())) {
				if (sm != null) {
					// ZLeB`FbN
					sm.checkPermission(new AudioPermission("play"));
				}
				result = new WCEClip(dinfo);
			}
		}
		
		if (result == null) {
			throw new LineUnavailableException(info.toString());
		}
		
		// Xiǉ
		result.addLineListener(new LineListener() {
			public void update(LineEvent e) {
				LineEvent.Type type = e.getType();
				boolean open = (type == LineEvent.Type.OPEN);
				boolean close = (type == LineEvent.Type.CLOSE);
				Line line = e.getLine();
				if (open) {
					if (e instanceof SourceDataLine) {
						sourceLineList.add(line);
					} else if (e instanceof TargetDataLine) {
						targetLineList.add(line);
					}
				} else if (close) {
					if (e instanceof SourceDataLine) {
						sourceLineList.remove(line);
					} else if (e instanceof TargetDataLine) {
						targetLineList.remove(line);
					}
				}
			}
		});
					
		return result;
	}
	
	public int getMaxLines(Line.Info info) {
		// ToDo: 
		return AudioSystem.NOT_SPECIFIED;
	}
	
	/**
	 * łɃI[vĂSourceDataLine̔zԂ
	 */
	public Line[] getSourceLines() {
		// ZLeB`FbN
		SecurityManager sm = System.getSecurityManager();
		if (sm != null) {
			sm.checkPermission(new AudioPermission("play"));
		}
		
		return (Line[]) this.sourceLineList.toArray(new Line[0]);
	}
	
	/**
	 * łɃI[vĂTargetDataLien̔zԂB
	 */
	public Line[] getTargetLines() {
		// ZLeB`FbN
		SecurityManager sm = System.getSecurityManager();
		if (sm != null) {
			sm.checkPermission(new AudioPermission("record"));
		}

		return (Line[]) this.targetLineList.toArray(new Line[0]);
	}

	public void synchronize(Line[] lines,
                 boolean maintainSync) {
		// ToDo: 
		throw new IllegalArgumentException();
	}
	
	public void unsynchronize(Line[] lines) {
		// ToDo: 
	}
	
	public boolean isSynchronizationSupported(Line[] lines,
											  boolean maintainSync) {
		// ToDo: 
		return false;
	}
	
	public Control[] getControls() {
		// ToDo: 
		return new Control[0];
	}
	
	public boolean isControlSupported(Control.Type control) {
		// ToDo: 
		return false;
	}
	
	public Control getControl(Control.Type control) {
		// ToDo: 
		throw new IllegalArgumentException();
	}

}
