/*
 * yalloc.h     for memory.c
 *
 *  This memory allocating routines pre-suppose the following system:
 *      1.  Heap area is contiguous in a process.  Moreover, brk() or sbrk()
 *          is not used by the programs which use malloc().
 *      2.  Heap area grows to larger address.
 *      3.  Internal representation of integer is 2's complement.
 *  The mode of error check and some other behavior are specified by user
 *      program setting the value of `memcheck' with macros MERR_*.
 *  The function to be executed on error is specified by `merrfunc'.
 *
 * 1993/08      V.1.0       kmatsui
 * 1996/09      V.2.0       kmatsui
 * 1997/03      V.2.1       kmatsui
 * 1998/05      V.2.2       kmatsui
 * 1998/11      V.2.3       kmatsui
 * 2003/06      V.2.4       kmatsui
 * 2003/09      V.2.5       kmatsui
 */

#include    <stddef.h>
#include    <stdlib.h>

/*
 * The following several definitions and declarations should be
 * re-implemented for each system.
 */

#define _NO_GLOBAL  1
            /* 0: global variables indicating heap-base and heap-top exist  */
            /* 1: global variables indicating heap area don't exist */
#if     !_NO_GLOBAL
#define _brklvl     _brklvl     /* variable to point the current heap top   */
            /* __brklvl:    __TURBOC__ small data memory model      */
            /* _brklvl:     __TURBOC__ large data memory model      */
#define _heapbase   _heapbase   /* variable to point the base of heap       */
            /* __heapbase:  __TURBOC__ small data memory model      */
            /* _heapbase:   __TURBOC__ large data memory model      */
#endif

#define _NOMEM      0
    /* 0: errno is set by brk() or sbrk() when brk() or sbrk() has failed
     * non-0 (ENOMEM or so): errno is set by malloc() when brk() or sbrk()
     * has failed (LSI_C, DJGPP, WIN32)
     */

/* One of the following 3 should be enabled for MS-DOS      */
#if     0   /* for MS-DOS small data memory model of __TURBOC__     */
#define _CORELEFT   coreleft
            /* name of the function to know available heap  */
#elif   0   /* for MS-DOS small data memory model of other than __TURBOC__  */
#define _SMALL
#elif   0   /* for large data memory model of MS-DOS        */
#define _LARGE
#endif

#if defined _LARGE
#define _HUGE       __huge          /* __huge or huge       */
#define _NALLOC     0x02000000UL
#define _FARCORELEFT    coreleft    /* name of the function to know heap    */
typedef unsigned long   _ptr_t;
#else
#define _HUGE                       /* no token */
#define _NALLOC     0x10000         /* unit size of heap to request to brk()*/
typedef unsigned    _ptr_t;
            /* integer type which can represent (char *), usually size_t    */
#endif

#define _RETURN_SIZE    0x80000     /* least size to return to OS.  */

typedef int         _unit_t;        /* type of worst-case alignment */

#define _MALLOC0_NULL   0           /* 1: malloc( 0) returns NULL   */
                        /* 0: malloc( 0) returns pointer to block of size 0 */

#define _PROTO      1   /* 1: prototype declaration is permitted    */
                        /* 0: prototype declaration is not permitted        */

#ifndef _MEM_DEBUG      /* maybe defined by command line    */
#ifdef DEBUG
#define _MEM_DEBUG  1   /* 1: link list_*() and can use all the debug mode  */
                        /* 0: only linked list and free area are checked    */
#else

#define _MEM_DEBUG	0

#endif

#endif

#if     _MEM_DEBUG
#define _GETENV     10
    /* get environmental variables on what count of malloc() calls  */
#endif

/*
 * The following definitions and declarations should not be changed.
 */

#define _PMAX       (~(_ptr_t)0)    /* highest value of data pointer*/
#define _ODD        (sizeof (_unit_t) - 1)      /* too small to allocate    */
#define _CELLSIZE   ((sizeof (_Header) + _ODD) & ~_ODD)
/* minimum multiple of sizeof (_unit_t) not less than sizeof (_Header)      */
#define _ALLOCATED( ptr)    \
        ((_PMAX - _CELLSIZE - sizeof (_unit_t) * 2) < (_ptr_t) ptr)
/* _next of allocated block, i.e. impossible _next pointer of free block    */
#define _FMAGIC     0xEF
/* Magic character written at 1st byte of free area to watch illegal writing*/

typedef struct _header {            /* cell header  */
    struct _header _HUGE *_next;    /* next cell on free list       */
                    /* magic for size of trailing garbage on allocated block*/
#if _MEM_DEBUG
    unsigned    _count;             /* the number of calls of malloc(), etc.*/
    int         _line;              /* the line-num where malloc() is called*/
    char        *_file;             /* the file where malloc() is called    */
#endif
    _ptr_t      _size;              /* size of this cell (including header) */
} _Header;

#include    "xalloc.h"              /* the publicized macros    */
