﻿

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Gecko;
using System.Text.RegularExpressions;
using WeifenLuo.WinFormsUI.Docking;

namespace geckoFXbrowser
{




    public partial class browserDoc : DockContent
    {
        private bool b_addNewentry = false;

        #region BrowserEvent

        private void geckoWebBrowser1_HistoryNewEntry(object sender, GeckoHistoryEventArgs e)
        {
            //ドキュメント読み込み完了後に、履歴を追加
            b_addNewentry = true;
        }

        /// <summary>
        /// ステータステキストが変わったら、イベントを発生させる
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void geckoWebBrowser1_StatusTextChanged_1(object sender, EventArgs e)
        {
            if(OnStatusChange != null)
                OnStatusChange(this, this.geckoWebBrowser1.StatusText);
        }



        private void geckoWebBrowser1_Navigating(object sender, GeckoNavigatingEventArgs e)
        {
            mouseOverelementsStack.Clear();
            weblib.b_navigatingFired = true;
            weblib.b_DocCompleted = false;
        }

        private void geckoWebBrowser1_DocumentCompleted(object sender, EventArgs e)
        {
            if(geckoWebBrowser1.Document == null) return;

            this.Text = geckoWebBrowser1.Document.Title;
            this.comboBox_URL.Text = geckoWebBrowser1.Url.ToString();

            //******************************************
            //ココで完結させる
            while(this.geckoWebBrowser1.IsAjaxBusy)
            {
                System.Threading.Thread.Sleep(10);
                Application.DoEvents();
                //↓これないと固まることが。。
                Application.RaiseIdle(new EventArgs());
            }

            //再入を防ぐため、タイマーで発火
            this.timer1.Enabled = true;
        }


        private void timer1_Tick(object sender, EventArgs e)
        {
            //タイマー止める
            this.timer1.Enabled = false;
            OnAfterDocComp();
        }

        #endregion

        #region AfterDocComp
        public delegate void AfterDocEventHandler(object sender, System.EventArgs e);
        public event AfterDocEventHandler AfterDocComp;

        private void OnAfterDocComp()
        {
            //ドキュメント読み込み完了後に、履歴を追加
            if(b_addNewentry && OnHistoryNewEntry != null)
            {
                OnHistoryNewEntry(this, this.geckoWebBrowser1.Url);
            }

            weblib.b_navigatingFired = false;
            weblib.b_DocCompleted = true;
            b_addNewentry = false;


            if(AfterDocComp != null)
            {
                AfterDocComp(this, EventArgs.Empty);
            }

        }




        #endregion
    }
}