﻿using System;
using System.Windows.Forms;
using Irony.Interpreter;
using System.Diagnostics;

using FastColoredTextBoxNS;


namespace myScriptableBrowser
{
    public partial class MainForm : Form
    {

        private void toolStripButton_go_Click(object sender , EventArgs e)
        {
            this.weblib.Navigate(this.toolStripTextBox_URL.Text);
        }

        private void toolStripButton_reset_Click(object sender , EventArgs e)
        {
            InitScript();
            formlib.infoTextBox.Text = "";
        }

        private void toolStripButton_suspend_Click(object sender , EventArgs e)
        {
            //if (Interpreter.App != null)
            //{
            //    //実行中ならサスペンド／再開する
            //    if (Interpreter.App.Status == AppStatus.Evaluating)
            //        Interpreter.App.SuspendRequested = !Interpreter.App.SuspendRequested;
            //}
            //else
            //{
            //    Interpreter.App.SuspendRequested = false;
            //}
        }

        public void Suspend(ScriptThread thread)
        {
            //var s = thread.CurrentNode.AsString;
            //this.textBox_info.Text = s + " " + DateTime.Now.ToString();

            //while (Interpreter.App.SuspendRequested)
            //{
            //    Application.DoEvents();
            //    System.Threading.Thread.Sleep(100);
            //}
        }

        private Irony.Parsing.ParseTree parsedScript ;

        private void toolStripButton_run_Click(object sender , EventArgs e)
        {
            Interpreter.App.OutputBuffer.Clear();
            //Interpreter.App.SuspendRequested = false;

            Interpreter.App.manualEvent_script = this.manualEvent1;

            var sw = new Stopwatch();
            sw.Start();

            try
            {
                //テキストを渡すEvaluateではなく、parsetreenodeを渡すを使う。
                parsedScript = Interpreter.Parser.Parse(this.textbox_script.Text);
                if (parsedScript.HasErrors())
                {
                    throw new ScriptException("Syntax errors found.");
                }

                System.Threading.Thread t2 = new System.Threading.Thread(new System.Threading.ThreadStart(runthread));
                t2.Start();

                //インタプリタに実行開始させる
                manualEvent1.Set();

                //Interpreter.App.Evaluate(parsedScript);
                //var printvisitor = new PrintVisitor();
                //astnode.AcceptVisitor(printvisitor);

                //this.textBox2.Text += Environment.NewLine + printvisitor.s;
            }
            catch (ScriptException ex)
            {
                MessageBox.Show(ex.Location.ToUiString() + ex.Message);
            }

            sw.Stop();

        }
        private void runthread()
        {
            Interpreter.App.Evaluate(parsedScript);
        }




        private void toolStripButton_test_Click(object sender , EventArgs e)
        {
            //MessageBox.Show("ボタンクリックされました");

            //var f = new System.Drawing.Font(textbox_script.Font.FontFamily , textbox_script.Font.SizeInPoints + 1.0f , textbox_script.Font.Style);

            //textbox_script.Font = f;
            //textbox_script.OnTextChanged();

            ////string s ="";
            ////var regoptions = Enum.GetNames(typeof(System.Text.RegularExpressions.RegexOptions));
            ////foreach (var item in regoptions)
            ////{
            ////    s += item + Environment.NewLine;
            ////}
            ////this.textBox_info.Text = s;

            string s = "";
            var colors = typeof(System.Drawing.Color).GetProperties();
            foreach (var item in colors)
            {
                s += item.ToString() + Environment.NewLine;
            }
            this.textBox_info.Text = s;


            ////PictureBox PictureBox1 = new PictureBox(); 
            ////Graphics g = PictureBox1.CreateGraphics();
            ////FontFamily[] ffs = FontFamily.GetFamilies(g);

            //////////InstalledFontCollectionオブジェクトの取得
            ////////System.Drawing.Text.InstalledFontCollection ifc =
            ////////    new System.Drawing.Text.InstalledFontCollection();
            //////////インストールされているすべてのフォントファミリアを取得
            ////////FontFamily[] ffs = ifc.Families;

            ////foreach (var item in ffs)
            ////{
            ////    System.Diagnostics.Debug.WriteLine(item.Name);
            ////}
            //new Form2().Show();


        }


        private void 切り取りTToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            textb.Cut();
        }


        private void コピーCToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            textb.Copy();
        }

        private void 貼り付けPToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            textb.Paste();
        }

        private void 元に戻すUToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            textb.Undo();
        }

        private void やり直しRToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            if(textb is FastColoredTextBox)
                textb.Redo();
        }

        private void すべて選択AToolStripMenuItem_Click(object sender , EventArgs e)
        {
            dynamic textb = GetactiveTextbox();
            textb.SelectAll();
        }




        private object GetactiveTextbox()
        {
            var tb = getActiveTextbox();
            var fctb = getActiveFastColoredTextBox();
            dynamic textb;

            if (tb == null)
                textb = fctb;
            else
                textb = tb;

            return textb;
        }

        ////参考URL
        ////http://blog.witchcraft-works.net/article/118152910.html
        /// <summary>
        /// アクティブなコントロールがテキストボックスか調べる
        /// </summary>
        /// <returns></returns>
        private TextBox getActiveTextbox()
        {
            ContainerControl containerControl;

            if(this.ActiveControl is TextBox)
            {
                return (TextBox)this.ActiveControl;
            }
            else if(this.ActiveControl is ContainerControl)
            {
                containerControl = (ContainerControl)this.ActiveControl;
                while(containerControl.ActiveControl is ContainerControl)
                {
                    containerControl = containerControl.ActiveControl as ContainerControl;
                }

                if(containerControl.ActiveControl is TextBox)
                {
                    return (TextBox)containerControl.ActiveControl;
                }
            }
            return null;
        }


        private FastColoredTextBoxNS.FastColoredTextBox getActiveFastColoredTextBox()
        {
            ContainerControl containerControl;

            if (this.ActiveControl is FastColoredTextBox)
            {
                return (FastColoredTextBox)this.ActiveControl;
            }
            else if (this.ActiveControl is ContainerControl)
            {
                containerControl = (ContainerControl)this.ActiveControl;
                while (containerControl.ActiveControl is ContainerControl)
                {
                    if (containerControl.ActiveControl is FastColoredTextBox)
                        return (FastColoredTextBox)containerControl.ActiveControl;

                    containerControl = containerControl.ActiveControl as ContainerControl;
                }
            }
            return null;
        }



    }
}
