/*
  =============================================================================
  
   Class   : NOS設定ファイル
   
  =============================================================================
*/

/*
  -----------------------------------------------------------------------------
  
  Define : Methodが返す値
  
  -----------------------------------------------------------------------------
*/
#define NOS_WAIT  0       /* 待機ステータス／待機要求 (算術でfalse) */
#define NOS_NONE  1       /* 待機ステータス／現状維持 (算術でtrue) */
#define NOS_ERROR -1      /* 待機ステータス／パラメータエラー */

/*
  -----------------------------------------------------------------------------
  
  Define : 各機能の有効無効
  
  -----------------------------------------------------------------------------
*/
#define USE_NOS_B0 0x01
#define USE_NOS_B1 0x02
#define USE_NOS_B2 0x04
#define USE_NOS_B3 0x08
#define USE_NOS_B4 0x10
#define USE_NOS_B5 0x20
#define USE_NOS_B6 0x40
#define USE_NOS_B7 0x80

#define USE_NOS_DEBUG (USE_NOS_B0 | USE_NOS_B1 | USE_NOS_B2 | USE_NOS_B3)
                                /* デバッグモード */
                                /*  0:範囲外パラメータ値の判定 */
                                /*  1:無効メッセージ／メモリブロックの検出 */
                                /*  2:二重待機要求発生の検出 */
                                /*  3:タスクからのスケジューラ呼び出しの無効化 */

#define USE_NOS_TIMER (USE_NOS_B0)
                                /* タイマー待機 */
                                /*  0:タイマー待機有効 */

#define USE_NOS_MSG (USE_NOS_B0 | USE_NOS_B1 | USE_NOS_B2)
                                /* メッセージ通信 */
                                /*  0:メッセージ通信有効 */
                                /*  1:タスク情報付加 */
                                /*  2:高速メッセージ返却モード有効 */

#define USE_NOS_EVENT (USE_NOS_B0)
                                /* イベント同期 */
                                /*  0:イベント同期有効 */

#define USE_NOS_RESRC (USE_NOS_B0 | USE_NOS_B1)
                                /* リソース共有 */
                                /*  0:リソース共有有効 */
                                /*  1:優先度上限プロトコル有効 */

#define USE_NOS_MEM (USE_NOS_B0 | USE_NOS_B1)
                                /* 動的メモリ確保 */
                                /*  0:動的メモリ確保有効 */
                                /*  1:断片化解消モード */

#define USE_NOS_TICK (USE_NOS_B0 | USE_NOS_B1)
                                /* タイムスライス */
                                /*  0:タイムスライス有効 */
/*
  -----------------------------------------------------------------------------
  
  Define : メモリブロック
  
  -----------------------------------------------------------------------------
*/
#define NOS_MEM_ALLOC 7         /* ページサイズ ( 1 << NOS_MEM_ALLOC) */
#define NOS_MEM_PAGE unsigned long int

/*
  -----------------------------------------------------------------------------
  
  Define : TICK値
  
  -----------------------------------------------------------------------------
*/
#define NOS_TICK_TIME 5         /* TICK値 */

/*
  -----------------------------------------------------------------------------
  
  Macoro : Message構造体ヘッダ部
  
  -----------------------------------------------------------------------------
*/
#if USE_NOS_MSG & USE_NOS_B1
#define NOS_MSG struct Nos_Link *next; unsigned int pri;    \
    int own;                                                \
    int send
#else
#define NOS_MSG struct Nos_Link *next; unsigned int pri;    \
    int own
#endif

/*
  -----------------------------------------------------------------------------
  
  CLASS : Message構造体ヘッダ部
  
  -----------------------------------------------------------------------------
*/
struct Nos_Msg
{
    NOS_MSG;                    /* NOS_LINK + own + send */
};

/*
  -----------------------------------------------------------------------------
  
  CLASS : Message構造体バッファ （定義したユーザーメッセージ構造体をセット）
  
  -----------------------------------------------------------------------------
*/
struct Nos_Msg_User
{
    NOS_MSG;                    /* メッセージの先頭には必須 */
    unsigned char mes[128 - (sizeof(struct Nos_Msg))];
                                /* デフォルトバッファサイズ */
};

#define NUM_BOX0_MSG 8          /* メッセージ数 */

struct Nos_Buf
{
    struct Nos_Msg_User user[NUM_BOX0_MSG];
};

/*
  -----------------------------------------------------------------------------
  
  Define : イベント
  
  -----------------------------------------------------------------------------
*/
enum No_Nos_Event {
    /*  */
    /* 最後は必ず NUM_NOS_EVENTを定義 */
    /*  */
    
    NOS_EVENT_00 = 0x00,        /* 仮シンボル */
    NOS_EVENT_01,

    NUM_NOS_EVENT               /* イベント数 */
};


/*
  -----------------------------------------------------------------------------
  
  Define : リソース
  
  -----------------------------------------------------------------------------
*/
enum No_Nos_Resrc {
    /*  */
    /* 最後は必ず NUM_NOS_RESRCを定義 */
    /*  */

    NOS_RESRC_00 = 0x00,        /* 仮シンボル */
    NOS_RESRC_01,               /* 仮シンボル */

    NUM_NOS_RESRC               /* システムで管理できるリソースの数 */
};

/*
  -----------------------------------------------------------------------------
  
  Define : メッセージボックス番号
  
  -----------------------------------------------------------------------------
*/
#define NOS_MSG_PRI 32          /* デフォルトメッセージライオリティ */

enum No_Nos_Box {
    /*  */
    /* 最後は必ず NUM_MSG_BOXを定義 */
    /*  */

    MSG_BOX_NOS = 0x00,
    MSG_BOX_TASK1,
    MSG_BOX_TASK2,

    NUM_MSG_BOX                 /* メッセージボックスの数 */
};

/*
  -----------------------------------------------------------------------------
  
  Define : タスク数
  
  -----------------------------------------------------------------------------
*/
enum No_Nos_Task {
   
    NOS_TASK = 0x00,            /* システムタスク */

    /*  */
    /* NOS_TASKからNUM_NOS_TASK間にタスクIDを定義するが、追加する部分は */
    /* 動的に割り当てられるので意味があるのはNOS_TASKとNUM_NOS_TASKだけ。 */
    /*  */

    NOS_TASK01,                 /* for DEBUG */
    NOS_TASK02,                 /* for DEBUG */

    NUM_NOS_TASK                /* システムで管理できるタスクの数 */
};

/*
  -----------------------------------------------------------------------------
  
   Define : タスクの優先順位
  
  -----------------------------------------------------------------------------
*/
enum Pri_Nos_Task {

	TASK_PRI = 0x00,

	MAX_TASK_PRI
};
