// Copyright 2010 The Native Client SDK Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can
// be found in the LICENSE file.


#include <stdio.h>
#include <stdlib.h>
#include <ppapi/c/pp_errors.h>
#include <ppapi/c/ppb_instance.h>
#include <ppapi/cpp/module.h>
#include <ppapi/cpp/var.h>
#include <ppapi/cpp/url_response_info.h>
#include <boost/format.hpp>
#include <string>
#include <vector>
#include <boost/xpressive/xpressive.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/format.hpp>

#include "geturl_handler.h"

namespace  x = boost::xpressive;

extern void LogMsg (void* instance,const char* format,...);

namespace {
bool IsError(int32_t result) {
  return ((PP_OK != result) && (PP_OK_COMPLETIONPENDING  != result));
}
}  // namespace

std::string GetURLHandler::js_empty_;

GetURLHandler* GetURLHandler::Create(pp::Instance* instance,
                                     const std::string& url,std::vector<char>& result_data,complete_func_type func ) {
  return new GetURLHandler(instance, url,result_data,func);
}

GetURLHandler::GetURLHandler(pp::Instance* instance,
                             const std::string& url,std::vector<char>& result_data,complete_func_type func)
    : instance_(instance),
      url_(url),
      url_request_(instance),
      url_loader_(instance),
      url_response_body_(result_data),
      cc_factory_(this),load_success_(false) ,received_bytes_(0),total_bytes_(0),func_(func),status_(init){
    url_response_body_.clear();
    url_request_.SetURL(url);
    url_request_.SetMethod("GET");
  // 
}

GetURLHandler::~GetURLHandler() {
}

bool GetURLHandler::Start() {
  LogMsg(instance_,"GetURLHandler::Start () Enter" );
  pp::CompletionCallback cc = cc_factory_.NewCallback(&GetURLHandler::OnOpen);
  int32_t res = url_loader_.Open(url_request_, cc);
  LogMsg(instance_,"GetURLHandler::Start::result = %d",res);
  if ((PP_OK_COMPLETIONPENDING) != res )
    cc.Run(res);
  
  return !IsError(res);
}

void GetURLHandler::OnOpen(int32_t result) {
  LogMsg(instance_,"GetURLHandler::OnOpen::result = %d",result);
  pp::URLResponseInfo info(url_loader_.GetResponseInfo());
  LogMsg(instance_,"GetURLHandler::OnOpen::result = %d,Status Code = %d",result,info.GetStatusCode());
  LogMsg(instance_,"Headers: %s",info.GetProperty(PP_URLRESPONSEPROPERTY_HEADERS).AsString().c_str());
  if (result < 0 || info.GetStatusCode() >= 400){
    std::string result_str((boost::format("pp::URLLoader::Open() failed: %d %s") % result % info.GetStatusLine().AsString()).str());
    LogMsg(instance_, result_str.c_str());
    func_(open,false,*this);
    CallbackEventJS(open,false,result_str);
    status_ = end;
    //    ReportResultAndDie(url_, "pp::URLLoader::Open() failed", false);
  } else {
    x::sregex  reg =  "Content-Length: "  >> ( x::s1 = +x::_d ) ;
    //x::sregex reg = x::sregex::compile("Content\\-Length\\:\\s([0-9]+)\\s");
    x::smatch m;
    if(x::regex_search(info.GetProperty(PP_URLRESPONSEPROPERTY_HEADERS).AsString(),m,reg))
    {
      total_bytes_ = boost::lexical_cast<int32_t>(m[1].str());
      LogMsg(instance_, "regex:match() success");
    };
    LogMsg(instance_, "pp::URLLoader::Open() Success.");
    CallbackEventJS(open,true,pp::Var((int32_t)total_bytes_));
    status_ = open;
    func_(open,true,*this);
    ReadBody();
  }
}

  void GetURLHandler::CallbackEventJS(status_id id,bool status,const pp::Var& reason)
  {
    LogMsg(instance_, "CallbackEventJS");
    if(reason.is_string()){
      instance_->PostMessage(pp::Var((boost::format("GetURLHandler:%d:%d:%s") % id % status % reason.AsString()).str()));
    } else {
      instance_->PostMessage(pp::Var((boost::format("GetURLHandler:%d:%d:%d") % id % status % reason.AsInt()).str()));
    }
  }


void GetURLHandler::OnRead(int32_t result) {
  result_ = result;
  static int count = 0;
  pp::URLResponseInfo info(url_loader_.GetResponseInfo());

  if (result < 0 && info.GetStatusCode() >= 400) {
    // G[
    result_string_ =  (boost::format("pp::URLLoader::OnRead() file: %s result: %d status code:%d") % url_.c_str() % result %  info.GetStatusCode()).str();
    LogMsg(instance_, result_string_.c_str());
    load_success_ = false;
    CallbackEventJS(loading,load_success_,result_string_);
    func_(loading,load_success_,*this);
    status_ = end;
  } else if (result != 0 ) {
    /*Xe[^XR[h`FbN*/
      
    int32_t num_bytes = result < kBufferSize ? result : sizeof(buffer_);
    url_response_body_.reserve(url_response_body_.size() + num_bytes);
    url_response_body_.insert(url_response_body_.end(),
                                buffer_,
                                buffer_ + num_bytes);

    //pp::FileRef_Dev d(info.
      //url_loader_.GetDownloadProgress(&received_bytes_,&total_bytes_);
      received_bytes_ += num_bytes;
      count = (++count) & 0x3;
      if(count == 0){
        CallbackEventJS(loading,true,(int32_t)(received_bytes_));
        LogMsg(instance_,"pp::URLLoader::OnRead() File: %s Success: %d bytes Status: %d" ,url_.c_str(),num_bytes,info.GetStatusCode());
      }

      ReadBody();
  } else {  // result == 0, end of stream
    load_success_ = true;
    LogMsg(instance_,"Load Success. File Size is %d bytes.\n",url_response_body_.size());
    CallbackEventJS(complete,load_success_,(int32_t)(url_response_body_.size()));
    func_(complete,load_success_,*this);
    status_ = end;
  }
}
/* TODO: iԂ̓ǂݎ */

void GetURLHandler::ReadBody() {
  // Reads the response body (asynchronous) into this->buffer_.
  // OnRead() will be called when bytes are received or when an error occurs.
  // Look at <ppapi/c/dev/ppb_url_loader> for more details.
  pp::CompletionCallback cc = cc_factory_.NewCallback(&GetURLHandler::OnRead);
  int32_t res = url_loader_.ReadResponseBody(buffer_,
                                             sizeof(buffer_),
                                             cc);
  if (PP_OK_COMPLETIONPENDING  != res)
    cc.Run(res);
}
//
//void GetURLHandler::ReportResultAndDie(const std::string& fname,
//                                       const std::string& text,
//                                       bool success) {
//  ReportResult(fname, text, success);
//  delete this;
//}
//
//void GetURLHandler::ReportResult(const std::string& fname,
//                                 const std::string& text,
//                                 bool success) {
//  if (success)
//    printf("GetURLHandler::ReportResult(Ok).\n");
//  else
//    printf("GetURLHandler::ReportResult(Err). %s\n", text.c_str());
//  fflush(stdout);
//  pp::Module* module = pp::Module::Get();
//  if (NULL == module)
//    return;
//
//  pp::Instance* instance = module->InstanceForPPInstance(instance_id_);
//  if (NULL == instance)
//    return;
//
//  pp::Var window = instance->GetWindowObject();
//  // calls JavaScript function reportResult(url, result, success)
//  // defined in geturl.html.
//  pp::Var exception;
//  window.Call("reportResult", fname, text, success, &exception);
//}

