/**********************************************************-*-verilog-*-
 *
 *	DESpSBox ROM 2i
 *	$Id: sbrom24.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module sbrom24(clk5,
			   ea, eb, lna, lnb,
			   qa, qb);

	input			clk5;

	input [0:47] 	ea, eb;		// g]u̓͒l
	input [0:31] 	lna, lnb;	// k]uL
	output [0:31] 	qa, qb;		// o

`include "func_des.v"

	// RAM ɋ킷AhXȂ
	wire [5:0] 		ea1, ea2, ea3, ea4, ea5, ea6, ea7, ea8;
	assign 			{ea1, ea2, ea3, ea4, ea5, ea6, ea7, ea8} = sae(ea);

	wire [5:0] 		eb1, eb2, eb3, eb4, eb5, eb6, eb7, eb8;
	assign 			{eb1, eb2, eb3, eb4, eb5, eb6, eb7, eb8} = sae(eb);

	wire [3:0] 		la1, la2, la3, la4, la5, la6, la7, la8;
	assign 			{la1, la2, la3, la4, la5, la6, la7, la8} = lna;
	wire [3:0] 		lb1, lb2, lb3, lb4, lb5, lb6, lb7, lb8;
	assign 			{lb1, lb2, lb3, lb4, lb5, lb6, lb7, lb8} = lnb;

	/*
	 *	S1-S8(x4) DPROM (M4K)
	 */
	wire [0:3] 		qa1, qa2, qa3, qa4, qa5, qa6, qa7, qa8;
	wire [0:3] 		qb1, qb2, qb3, qb4, qb5, qb6, qb7, qb8;
	s11x4 sab1(4'b0, 1'b0, {ea1, la1}, 4'b0, {eb1, lb1}, 1'b0, clk5, qa1, qb1);
	//exemplar attribute sab1 NOOPT TRUE
	s22x4 sab2(4'b0, 1'b0, {ea2, la2}, 4'b0, {eb2, lb2}, 1'b0, clk5, qa2, qb2);
	//exemplar attribute sab2 NOOPT TRUE
	s33x4 sab3(4'b0, 1'b0, {ea3, la3}, 4'b0, {eb3, lb3}, 1'b0, clk5, qa3, qb3);
	//exemplar attribute sab3 NOOPT TRUE
	s44x4 sab4(4'b0, 1'b0, {ea4, la4}, 4'b0, {eb4, lb4}, 1'b0, clk5, qa4, qb4);
	//exemplar attribute sab4 NOOPT TRUE
	s55x4 sab5(4'b0, 1'b0, {ea5, la5}, 4'b0, {eb5, lb5}, 1'b0, clk5, qa5, qb5);
	//exemplar attribute sab5 NOOPT TRUE
	s66x4 sab6(4'b0, 1'b0, {ea6, la6}, 4'b0, {eb6, lb6}, 1'b0, clk5, qa6, qb6);
	//exemplar attribute sab6 NOOPT TRUE
	s77x4 sab7(4'b0, 1'b0, {ea7, la7}, 4'b0, {eb7, lb7}, 1'b0, clk5, qa7, qb7);
	//exemplar attribute sab7 NOOPT TRUE
	s88x4 sab8(4'b0, 1'b0, {ea8, la8}, 4'b0, {eb8, lb8}, 1'b0, clk5, qa8, qb8);
	//exemplar attribute sab8 NOOPT TRUE

	/*
	 *	o͌MUX
	 */
	assign 			qa = {qa1, qa2, qa3, qa4, qa5, qa6, qa7, qa8};
	assign 			qb = {qb1, qb2, qb3, qb4, qb5, qb6, qb7, qb8};

endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
